% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscale.R
\name{multiscale}
\alias{multiscale}
\title{Multiscale SMACOF}
\usage{
multiscale(
  delta,
  type = c("ratio", "interval"),
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  kappa = 0.1,
  principal = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances. Warning: these will get transformed to the log scale, so make sure that log(delta)>=0.}

\item{type}{what optimal scaling type of MDS to fit. Currently one of "ratio" or "interval". Default is "ratio".}

\item{weightmat}{a matrix of finite weights}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{acc}{numeric accuracy of the iteration. Default is 1e-6.}

\item{itmax}{maximum number of iterations. Default is 10000.}

\item{verbose}{should iteration output be printed; if > 1 then yes}

\item{kappa}{As this is not exactly multiscale but an r-stress approximation, we have multiscale only for kappa->0. This argument can therefore be used to make the approximation more accurate by making it smaller. Default is 0.1.}

\item{principal}{If ‘TRUE’, principal axis transformation is applied to the final configuration}
}
\value{
a 'smacofP' object (inheriting from 'smacofB', see \code{\link{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed dissimilarities
\item tdelta: Observed explicitly transformed (log) dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats), optimally scaled and normalized 
\item confdist: Configuration dissimilarities, NOT normalized 
\item conf: Matrix of fitted configuration, NOT normalized
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model
\item weightmat: weighting matrix 
\item stress.m: Default stress (stress-1^2)
}
}
\description{
An implementation for maximum likelihood MDS aka multiscale that minimizes the multiscale stress by majorization with ratio and interval optimal scaling. Uses a repeat loop.
}
\section{Warning}{
 The input delta will internally get transformed to the log scale, so make sure that log(delta)>=0 otherwise it throws an error. It is often a good idea to use 1+delta in this case.
}

\examples{
dis<-smacof::kinshipdelta
res<-multiscale(as.matrix(dis),type="interval",itmax=1000)
res
summary(res)
plot(res)

}
\seealso{
\code{\link{rStressMin}}
}
