% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\alias{status.slurm_job}
\alias{status.default}
\alias{$.slurm_status}
\title{Check the status of a Slurm JOB}
\usage{
status(x)

\method{status}{slurm_job}(x)

\method{status}{default}(x)

\method{$}{slurm_status}(x, name)
}
\arguments{
\item{x}{Either a Job id, an object of class \code{slurm_job}, or an object of
class \code{slurm_status}.}

\item{name}{Character scalar. List of status to retrieve. This can be any of
\code{"done"}, \code{"failed"}, \code{"running"}, or \code{"pending"}.}
}
\value{
An integer with attributes of class \code{slurm_status}. The attributes
are integer vectors indicating which jobs fail in the categories of \code{done},
\code{failed}, \code{pending}, and \code{running} (see \link{JOB_STATE_CODES}). Possible return
values are:
\itemize{
\item \code{-1}: No job found. This may be a false negative as the job may still be
on it's way to be submitted.
\item \code{0}: Job completed.
\item \code{1}: All jobs are pending resource allocation or are on it's way to start.
\item \code{2}: All jobs are currently running.
\item \code{3}: One or more jobs are still running.
\item \code{99}: One or more jobs failed.
}

If the job is not an array, then function will return the corresponding code
but the attributes will only have a single number, 1, according to the state
of the job (completed, failed, pending).
}
\description{
Using the \link{sacct} function, it checks the status of a particular job and
returns information about its current state, with details regarding the
jobs (if an array) that are done, running, pending, or failed.
}
\examples{
\dontrun{

x <- Slurm_EvalQ(Sys.sleep(100), njobs = 2)

status(x) # A possible result: An integer with attributes
# Status: All jobs are pending resource allocation or are on it's way to start. (Code 1)
# This is a job array. The status of each job, by array id, is the following:
# done      :  -
# failed    :  -
# pending   : 1, 2.
# running   :  -

}
}
\seealso{
Other utilities: 
\code{\link{Slurm_clean}()},
\code{\link{Slurm_env}()},
\code{\link{Slurm_log}()},
\code{\link{WhoAmI}()},
\code{\link{parse_flags}()},
\code{\link{snames}()}

Other post submission: 
\code{\link{Slurm_clean}()},
\code{\link{Slurm_collect}()},
\code{\link{Slurm_log}()}
}
\concept{post submission}
\concept{utilities}
