% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/slfm_list.r
\name{slfm_list}
\alias{slfm_list}
\title{Fit SLFM to the matrices inside a directory}
\usage{
slfm_list(path = ".", recursive = TRUE, a = 2.1, b = 1.1, gamma_a = 1,
  gamma_b = 1, omega_0 = 0.01, omega_1 = 10, sample = 1000,
  burnin = round(0.25 * sample), lag = 1, degenerate = FALSE)
}
\arguments{
\item{path}{path to read the matrices from}

\item{recursive}{if the function should look recursively inside folders}

\item{a}{prior shape parameter for Gamma distribution}

\item{b}{prior scale parameter for Gamma distribution}

\item{gamma_a}{prior parameter for Beta distribution}

\item{gamma_b}{prior parameter for Beta distribution}

\item{omega_0}{prior variance of the spike component}

\item{omega_1}{prior variance of the slab component}

\item{sample}{sample size after burn-in}

\item{burnin}{burn-in size}

\item{lag}{lag for MCMC}

\item{degenerate}{use the degenerate version of mixture}
}
\description{
This function is used to fit a Bayesian sparse
latent factor model to a directory of numeric matrices.
}

