% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjSDM_cv.R
\name{sjSDM_cv}
\alias{sjSDM_cv}
\title{Cross validation of elastic net tuning}
\usage{
sjSDM_cv(
  Y,
  env = NULL,
  biotic = bioticStruct(),
  spatial = NULL,
  tune = c("random", "grid"),
  CV = 5L,
  tune_steps = 20L,
  alpha_cov = seq(0, 1, 0.1),
  alpha_coef = seq(0, 1, 0.1),
  alpha_spatial = seq(0, 1, 0.1),
  lambda_cov = 2^seq(-10, -1, length.out = 20),
  lambda_coef = 2^seq(-10, -0.5, length.out = 20),
  lambda_spatial = 2^seq(-10, -0.5, length.out = 20),
  device = "cpu",
  n_cores = NULL,
  n_gpu = NULL,
  sampling = 5000L,
  blocks = 1L,
  ...
)
}
\arguments{
\item{Y}{species occurrence matrix}

\item{env}{matrix of environmental predictors or object of type \code{\link{linear}}, or \code{\link{DNN}}}

\item{biotic}{defines biotic (species-species associations) structure, object of type \code{\link{bioticStruct}}. Alpha and lambda have no influence}

\item{spatial}{defines spatial structure, object of type \code{\link{linear}}, or \code{\link{DNN}}}

\item{tune}{tuning strategy, random or grid search}

\item{CV}{n-fold cross validation or list of test indices}

\item{tune_steps}{number of tuning steps}

\item{alpha_cov}{weighting of l1 and l2 on covariances: \eqn{(1 - \alpha) * |cov| + \alpha ||cov||^2}}

\item{alpha_coef}{weighting of l1 and l2 on coefficients: \eqn{(1 - \alpha) * |coef| + \alpha ||coef||^2}}

\item{alpha_spatial}{weighting of l1 and l2 on spatial coefficients: \eqn{(1 - \alpha) * |coef_sp| + \alpha ||coef_sp||^2}}

\item{lambda_cov}{overall regularization strength on covariances}

\item{lambda_coef}{overall regularization strength on coefficients}

\item{lambda_spatial}{overall regularization strength on spatial coefficients}

\item{device}{device, default cpu}

\item{n_cores}{number of cores for parallelization}

\item{n_gpu}{number of GPUs}

\item{sampling}{number of sampling steps for Monte Carlo integration}

\item{blocks}{blocks of parallel tuning steps}

\item{...}{arguments passed to sjSDM, see \code{\link{sjSDM}}}
}
\value{
An S3 class of type 'sjSDM_cv' including the following components:

\item{tune_results}{Data frame with tuning results.}
\item{short_summary}{Data frame with averaged tuning results.}
\item{summary}{Data frame with summarized averaged results.}
\item{settings}{List of tuning settings, see the arguments in \code{\link{DNN}}.}
\item{data}{List of Y, env (and spatial) objects.}
\item{config}{List of \code{\link{sjSDM}} settings, see arguments of \code{\link{sjSDM}}.}
\item{spatial}{Logical, spatial model or not.}

Implemented S3 methods include \code{\link{sjSDM.tune}}, \code{\link{plot.sjSDM_cv}}, \code{\link{print.sjSDM_cv}}, and \code{\link{summary.sjSDM_cv}}
}
\description{
Cross validation of elastic net tuning
}
\examples{
\dontrun{
# simulate sparse community:
com = simulate_SDM(env = 5L, species = 25L, sites = 50L, sparse = 0.5)

# tune regularization:
tune_results = sjSDM_cv(Y = com$response,
                        env = com$env_weights, 
                        tune = "random", # random steps in tune-paramter space
                        CV = 2L, # 3-fold cross validation
                        tune_steps = 2L,
                        alpha_cov = seq(0, 1, 0.1),
                        alpha_coef = seq(0, 1, 0.1),
                        lambda_cov = seq(0, 0.1, 0.001), 
                        lambda_coef = seq(0, 0.1, 0.001),
                        n_cores = 2L,
                        sampling = 100L,
                        # small models can be also run in parallel on the GPU
                        iter = 2L # we can pass arguments to sjSDM via... 
                        )

# print overall results:
tune_results

# summary (mean values over CV for each tuning step)
summary(tune_results)

# visualize tuning and best points:
# best = plot(tune_results, perf = "logLik")

# fit model with best regularization paramter:
model = sjSDM.tune(tune_results)

summary(model)
}
}
\seealso{
\code{\link{plot.sjSDM_cv}}, \code{\link{print.sjSDM_cv}}, \code{\link{summary.sjSDM_cv}}, \code{\link{sjSDM.tune}}
}
