% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_xtab.R
\name{tab_xtab}
\alias{tab_xtab}
\alias{sjt.xtab}
\title{Summary of contingency tables as HTML table}
\usage{
tab_xtab(
  var.row,
  var.col,
  weight.by = NULL,
  title = NULL,
  var.labels = NULL,
  value.labels = NULL,
  wrap.labels = 20,
  show.obs = TRUE,
  show.cell.prc = FALSE,
  show.row.prc = FALSE,
  show.col.prc = FALSE,
  show.exp = FALSE,
  show.legend = FALSE,
  show.na = FALSE,
  show.summary = TRUE,
  drop.empty = TRUE,
  statistics = c("auto", "cramer", "phi", "spearman", "kendall", "pearson", "fisher"),
  string.total = "Total",
  digits = 1,
  tdcol.n = "black",
  tdcol.expected = "#339999",
  tdcol.cell = "#993333",
  tdcol.row = "#333399",
  tdcol.col = "#339933",
  emph.total = FALSE,
  emph.color = "#f8f8f8",
  prc.sign = "&nbsp;&#37;",
  hundret = "100.0",
  CSS = NULL,
  encoding = NULL,
  file = NULL,
  use.viewer = TRUE,
  remove.spaces = TRUE,
  ...
)

sjt.xtab(
  var.row,
  var.col,
  weight.by = NULL,
  title = NULL,
  var.labels = NULL,
  value.labels = NULL,
  wrap.labels = 20,
  show.obs = TRUE,
  show.cell.prc = FALSE,
  show.row.prc = FALSE,
  show.col.prc = FALSE,
  show.exp = FALSE,
  show.legend = FALSE,
  show.na = FALSE,
  show.summary = TRUE,
  drop.empty = TRUE,
  statistics = c("auto", "cramer", "phi", "spearman", "kendall", "pearson", "fisher"),
  string.total = "Total",
  digits = 1,
  tdcol.n = "black",
  tdcol.expected = "#339999",
  tdcol.cell = "#993333",
  tdcol.row = "#333399",
  tdcol.col = "#339933",
  emph.total = FALSE,
  emph.color = "#f8f8f8",
  prc.sign = "&nbsp;&#37;",
  hundret = "100.0",
  CSS = NULL,
  encoding = NULL,
  file = NULL,
  use.viewer = TRUE,
  remove.spaces = TRUE,
  ...
)
}
\arguments{
\item{var.row}{Variable that should be displayed in the table rows.}

\item{var.col}{Cariable that should be displayed in the table columns.}

\item{weight.by}{Vector of weights that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{title}{String, will be used as table caption.}

\item{var.labels}{Character vector with variable names, which will be used
to label variables in the output.}

\item{value.labels}{Character vector (or \code{list} of character vectors)
with value labels of the supplied variables, which will be used
to label variable values in the output.}

\item{wrap.labels}{Numeric, determines how many chars of the value, variable
or axis labels are displayed in one line and when a line break is inserted.}

\item{show.obs}{Logical, if \code{TRUE}, observed values are shown}

\item{show.cell.prc}{Logical, if \code{TRUE}, cell percentage values are shown}

\item{show.row.prc}{Logical, if \code{TRUE}, row percentage values are shown}

\item{show.col.prc}{Logical, if \code{TRUE}, column percentage values are shown}

\item{show.exp}{Logical, if \code{TRUE}, expected values are also shown}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.na}{logical, if \code{TRUE}, \code{\link{NA}}'s (missing values)
are added to the output.}

\item{show.summary}{Logical, if \code{TRUE}, a summary row with
chi-squared statistics, degrees of freedom and Cramer's V or Phi
coefficient and p-value for the chi-squared statistics.}

\item{drop.empty}{Logical, if \code{TRUE} and the variable's values are labelled,
values that have no observations are still printed in the table (with
frequency \code{0}). If \code{FALSE}, values / factor levels with no occurence
in the data are omitted from the output.}

\item{statistics}{Name of measure of association that should be computed. May
be one of \code{"auto"}, \code{"cramer"}, \code{"phi"}, \code{"spearman"},
\code{"kendall"}, \code{"pearson"} or \code{"fisher"}. See
\code{\link[sjstats]{xtab_statistics}}.}

\item{string.total}{Character label for the total column / row header}

\item{digits}{Amount of decimals for estimates}

\item{tdcol.n}{Color for highlighting count (observed) values in table cells. Default is black.}

\item{tdcol.expected}{Color for highlighting expected values in table cells. Default is cyan.}

\item{tdcol.cell}{Color for highlighting cell percentage values in table cells. Default is red.}

\item{tdcol.row}{Color for highlighting row percentage values in table cells. Default is blue.}

\item{tdcol.col}{Color for highlighting column percentage values in table cells. Default is green.}

\item{emph.total}{Logical, if \code{TRUE}, the total column and row will be emphasized with a
different background color. See \code{emph.color}.}

\item{emph.color}{Logical, if \code{emph.total = TRUE}, this color value will be used
for painting the background of the total column and row. Default is a light grey.}

\item{prc.sign}{The percentage sign that is printed in the table cells, in HTML-format.
Default is \code{"&nbsp;\%"}, hence the percentage sign has a non-breaking-space after
the percentage value.}

\item{hundret}{Default value that indicates the 100-percent column-sums (since rounding values
may lead to non-exact results). Default is \code{"100.0"}.}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions,
according to the \href{http://www.w3.org/Style/CSS/}{official CSS syntax}.
See 'Details' or \href{https://strengejacke.github.io/sjPlot/articles/table_css.html}{this package-vignette}.}

\item{encoding}{String, indicating the charset encoding used for variable and
value labels. Default is \code{NULL}, so encoding will be auto-detected
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{file}{Destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{Logical, if \code{TRUE}, the HTML table is shown in the IDE's
viewer pane. If \code{FALSE} or no viewer available, the HTML table is
opened in a web browser.}

\item{remove.spaces}{Logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}

\item{...}{Other arguments, currently passed down to the test statistics functions
\code{chisq.test()} or \code{fisher.test()}.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{page.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows contingency tables as HTML file in browser or viewer pane, or saves them as file.
}
\examples{
# prepare sample data set
data(efc)

# print simple cross table with labels
\dontrun{
if (interactive()) {
  tab_xtab(efc$e16sex, efc$e42dep)

  # print cross table with manually set
  # labels and expected values
  tab_xtab(
    efc$e16sex,
    efc$e42dep,
    var.labels = c("Elder's gender", "Elder's dependency"),
    show.exp = TRUE
  )

  # print minimal cross table with labels, total col/row highlighted
  tab_xtab(efc$e16sex, efc$e42dep, show.cell.prc = FALSE, emph.total = TRUE)

  # User defined style sheet
  tab_xtab(efc$e16sex, efc$e42dep,
           CSS = list(css.table = "border: 2px solid;",
                      css.tdata = "border: 1px solid;",
                      css.horline = "border-bottom: double blue;"))

  # ordinal data, use Kendall's tau
  tab_xtab(efc$e42dep, efc$quol_5, statistics = "kendall")

  # calculate Spearman's rho, with continuity correction
  tab_xtab(
    efc$e42dep,
    efc$quol_5,
    statistics = "spearman",
    exact = FALSE,
    continuity = TRUE
  )
}
}
}
