% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotGroupPropTable.R
\name{sjp.gpt}
\alias{sjp.gpt}
\title{Plot grouped proportional tables}
\usage{
sjp.gpt(x, y, groups, geom.colors = "Set1", geom.size = 4,
  shape.fill.color = "#f0f0f0", shapes = c(15, 16, 17, 18, 21, 22, 23, 24,
  25, 7, 8, 9, 10, 12), title = NULL, axisLabels = NULL,
  axisTitle.x = NULL, axisTitle.y = NULL, legendTitle = NULL,
  legendLabels = NULL, breakTitleAt = 50, breakLabelsAt = 15,
  breakLegendTitleAt = 20, breakLegendLabelsAt = 20, axisLimits = NULL,
  gridBreaksAt = NULL, showTotal = TRUE, annotateTotal = TRUE,
  showP = TRUE, showN = TRUE, hideLegend = FALSE, printPlot = TRUE)
}
\arguments{
\item{x}{categorical variable, where the proportion of each categorie in the
highest category of \code{y} will be printed along the x-axis.}

\item{y}{categorical or numeric variable. If not a binary variable, \code{y}
will be recoded into a binary variable, dichtomized at the highest
category and all remaining categories.}

\item{groups}{grouping variable, which will define the y-axis}

\item{geom.colors}{User defined color palette for geoms. If specified, must either be vector with color values
of same length as groups defined in \code{varGroup}, or a specific color brewer palette code (see 'Note').}

\item{geom.size}{size resp. width of the geoms (bar width or point size, depending on \code{type} argument).
Note that  bar and bin widths mostly need smaller values than dot sizes (i.e. if \code{type = "dots"}).
By default, \code{geom.size = NULL}, which means that this argument is automatically
adjusted depending on the plot type.}

\item{shape.fill.color}{optional color vector, fill-color for non-filled shapes}

\item{shapes}{numeric vector with shape styles, used to map the different
categories of \code{x}.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{axisLabels}{character vector with \code{groups} labels for the y-axis.}

\item{axisTitle.x}{title for the x-axis. By default, \code{""} is used, i.e. no title
is printed. If \code{axisTitle.x = NULL}, the variable name will be
automatically detected and used as title (see \code{\link[sjmisc]{set_label}})
for details).}

\item{axisTitle.y}{title for the-y axis. By default, \code{""} is used, i.e. no title
is printed. If \code{axisTitle.y = NULL}, variable name will be automatically
detected and used as title (see \code{\link[sjmisc]{set_label}}) for details).}

\item{legendTitle}{title of the plot legend, as string.}

\item{legendLabels}{a character vector with labels for the guide/legend.}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{axisLimits}{numeric vector of length 2, defining the range of the plot axis.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th
position a major grid is being printed.}

\item{showTotal}{logical, if \code{TRUE}, a total summary line for all aggregated
\code{groups} is added.}

\item{annotateTotal}{logical, if \code{TRUE} and \code{showTotal = TRUE},
the total-row in the figure will be highlighted with a slightly
shaded background.}

\item{showP}{logical, if \code{TRUE}, axis labels for groups will also contain
the results of the \code{\link[stats]{chisq.test}} of \code{x} and
\code{y} for each \code{groups}.}

\item{showN}{logical, if \code{TRUE}, axis labels for groups will also contain
the total number of cases in each \code{groups}.}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot
          (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot grouped proportional crosstables, where the proportion of
               each level of \code{x} for the highest category in \code{y}
               is plotted, for each subgroup of \code{groups}.
}
\examples{
library(sjmisc)
data(efc)

# the proportion of dependency levels in female
# elderly, for each family carer's relationship
# to elderly
sjp.gpt(efc$e42dep, efc$e16sex, efc$e15relat)

# proportion of educational levels in highest
# dependency category of elderly, for different
# care levels
sjp.gpt(efc$c172code, efc$e42dep, efc$n4pstu)
}

