% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotClusterAnalysis.R
\name{sjc.qclus}
\alias{sjc.qclus}
\title{Compute quick cluster analysis}
\usage{
sjc.qclus(data, groupcount = NULL, groups = NULL, method = "k",
  distance = "euclidean", agglomeration = "ward", iter.max = 20,
  algorithm = "Hartigan-Wong", showAccuracy = FALSE, title = NULL,
  axisLabels.x = NULL, axisTitle.x = "Cluster group characteristics",
  axisTitle.y = "Mean of z-scores", breakTitleAt = 40, breakLabelsAt = 20,
  breakLegendTitleAt = 20, breakLegendLabelsAt = 20, facetCluster = FALSE,
  geom.colors = "Paired", geom.size = 0.5, geom.spacing = 0.1,
  hideLegend = FALSE, showAxisLabels.x = TRUE, showAxisLabels.y = TRUE,
  showGroupCount = TRUE, showAccuracyLabels = FALSE, legendTitle = NULL,
  legendLabels = NULL, coord.flip = FALSE, reverseAxis.x = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{data}{The data frame containing all variables that should be used for the
cluster analysis.}

\item{groupcount}{The amount of groups (clusters) that should be retrieved. May also be
a set of initial (distinct) cluster centres, in case \code{method} is \code{"kmeans"}
(see \code{\link{kmeans}} for details on \code{centers} parameter). By default
(\code{NULL}), the optimal amount of clusters is calculated using the gap statistics
(see \code{\link{sjc.kgap}}. However, this works only with kmeans as \code{method}. If
\code{method} is \code{"hclust"}, you have to specify a groupcount. Use the \code{\link{sjc.elbow}}-function
to determine the group-count depending on the elbow-criterion. Use \code{\link{sjc.grpdisc}}-function
to inspect the goodness of grouping.}

\item{groups}{By default, this parameter is \code{NULL} and will be ignored. However, if you just want to plot
an already existing cluster solution without computing a new cluster analysis, specify \code{groupcount}
and \code{groups}. \code{groups} is a vector of same length as \code{nrow(data)} and indicates the group
classification of the cluster analysis. The group classification can be computed with the
\code{\link{sjc.cluster}} function.}

\item{method}{The method for computing the cluster analysis. By default (\code{"kmeans"}), a
kmeans cluster analysis will be computed. Use \code{"hclust"} to compute a hierarchical
cluster analysis. You can specify the initial letters only.}

\item{distance}{The distance measure to be used when \code{"method"} is \code{"hclust"} (for hierarchical
clustering). This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"}. See \code{\link{dist}}.
By default, method is \code{"kmeans"} and this parameter will be ignored.}

\item{agglomeration}{The agglomeration method to be used when \code{"method"} is \code{"hclust"} (for hierarchical
clustering). This should be one of \code{"ward"}, \code{"single"}, \code{"complete"}, \code{"average"},
\code{"mcquitty"}, \code{"median"} or \code{"centroid"}. Default is \code{"ward"} (see \code{\link{hclust}}).
Note that since R version > 3.0.3, the \code{"ward"} option has been replaced by either \code{"ward.D"}
or \code{"ward.D2"}. In such case, you may also use these values.
By default, method is \code{"kmeans"} and this parameter will be ignored.}

\item{iter.max}{the maximum number of iterations allowed. Only applies, if \code{method}
is \code{"kmeans"}. See \code{\link{kmeans}} for details on this parameter.}

\item{algorithm}{algorithm used for calculating kmeans cluster. Only applies, if \code{method}
is \code{"kmeans"}. May be one of \code{"Hartigan-Wong"} (default), \code{"Lloyd"} (used by SPSS),
or \code{"MacQueen"}. See \code{\link{kmeans}} for details on this parameter.}

\item{showAccuracy}{If \code{TRUE}, the \code{\link{sjc.grpdisc}} function will be called,
which computes a linear discriminant analysis on the classified cluster groups and plots a
bar graph indicating the goodness of classification for each group.}

\item{title}{Title of diagram as string.
Example: \code{title = "my title"}}

\item{axisLabels.x}{Labels for the x-axis breaks.
Example: \code{axisLabels.x = c("Label1", "Label2", "Label3")}. \cr
\strong{Note:} If you use the \code{\link[sjmisc]{read_spss}} function and the \code{\link[sjmisc]{get_val_labels}} function, you receive a
list object with label string. The labels may also be passed as list object. They will be coerced
to character vector automatically.}

\item{axisTitle.x}{A label for the x axis. useful when plotting histograms with metric scales where no category labels
are assigned to the x axis.}

\item{axisTitle.y}{A label for the y axis. useful when plotting histograms with metric scales where no category labels
are assigned to the y axis.}

\item{breakTitleAt}{Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{Determines how many chars of the labels are displayed in
one line and when a line break is inserted into the axis labels.}

\item{breakLegendTitleAt}{Determines how many chars of the legend title are displayed in
one line and when a line break is inserted into the legend title.}

\item{breakLegendLabelsAt}{Determines how many chars of the legend labels are displayed in
one line and when a line break is inserted into the axis labels.}

\item{facetCluster}{If \code{TRUE}, each cluster group will be represented by an own panel.
Default is \code{FALSE}, thus all cluster groups are plotted in a single graph.}

\item{geom.colors}{User defined color for bars.}

\item{geom.size}{Width of bars. Recommended values for this parameter are from 0.4 to 1.5}

\item{geom.spacing}{Spacing between bars. Default value is 0.1. If 0 is used, the grouped bars are sticked together and have no space
in between. Recommended values for this parameter are from 0 to 0.5}

\item{hideLegend}{Indicates whether legend (guide) should be shown or not.}

\item{showAxisLabels.x}{Whether x axis labels (cluster variables) should be shown or not.}

\item{showAxisLabels.y}{Whether y axis labels (z scores) should be shown or not.}

\item{showGroupCount}{if \code{TRUE} (default), the count within each cluster group is added to the
legend labels (e.g. \code{"Group 1 (n=87)"}).}

\item{showAccuracyLabels}{if \code{TRUE}, the accuracy-values for each cluster group is added to the
legend labels (e.g. \code{"Group 1 (n=87, accuracy=95.3)"}). Accuracy is calculated by \code{\link{sjc.grpdisc}}.}

\item{legendTitle}{Title of the diagram's legend.}

\item{legendLabels}{Labels for the guide/legend. Example: See \code{axisLabels.x}. If \code{legendLabels}
is \code{NULL} (default), the standard string \code{"Group <nr>"} will be used.}

\item{coord.flip}{If \code{TRUE}, the x and y axis are swapped.}

\item{reverseAxis.x}{if \code{TRUE}, the values on the x-axis are reversed.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
         want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Invisibly) returns an object with
          \itemize{
           \item \code{data}: the used data frame for plotting,
           \item \code{plot}: the ggplot object,
           \item \code{groupcount}: the number of found cluster (as calculated by \code{\link{sjc.kgap}})
           \item \code{classification}: the group classification (as calculated by \code{\link{sjc.cluster}}), including missing values, so this vector can be appended to the original data frame.
           \item \code{accuracy}: the accuracy of group classification (as calculated by \code{\link{sjc.grpdisc}}).
          }
}
\description{
Compute a quick kmeans or hierarchical cluster analysis and displays "cluster characteristics"
               as graph.
               \enumerate{
               \item If \code{method} is \code{kmeans}, this function first determines the optimal group count via gap statistics (unless parameter \code{groupcount} is specified), using the \code{\link{sjc.kgap}} function.
               \item A cluster analysis is performed by running the \code{\link{sjc.cluster}} function to determine the cluster groups.
               \item Then, all variables in \code{data} are scaled and centered. The mean value of these z-scores within each cluster group is calculated to see how certain characteristics (variables) in a cluster group differ in relation to other cluster groups.
               \item These results are plotted as graph.
               }
               This method can also be used to plot existing cluster solution as graph witouth computing
               a new cluster analysis. See parameter \code{groups} for more details.
}
\note{
See 'Note' in \code{\link{sjc.cluster}}
}
\examples{
\dontrun{
# k-means clustering of mtcars-dataset
sjc.qclus(mtcars)

# k-means clustering of mtcars-dataset with 4 pre-defined
# groups in a faceted panel
sjc.qclus(airquality,
          groupcount = 4,
          facetCluster = TRUE)}

# k-means clustering of airquality data
# and saving the results. most likely, 3 cluster
# groups have been found (see below).
airgrp <- sjc.qclus(airquality)

# "re-plot" cluster groups, without computing
# new k-means cluster analysis.
sjc.qclus(airquality,
          groupcount = 3,
          groups = airgrp$classification)
}
\references{
Maechler M, Rousseeuw P, Struyf A, Hubert M, Hornik K (2014) cluster: Cluster Analysis Basics and Extensions. R package.
}

