% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{dicho}
\alias{dicho}
\title{Dichotomize variables}
\usage{
dicho(var, dichBy = "median", dichVal = -1, asNum = FALSE)
}
\arguments{
\item{var}{The variable that should be dichotomized.}

\item{dichBy}{Indicates the split criterion where the variable is dichotomized.
\itemize{
  \item By default, \code{var} is split into two groups at the median (\code{dichBy = "median"} or \code{dichBy = "md"}).
  \item \code{dichBy = "mean"} (or \code{dichBy = "m"}) splits \code{var} into two groups at the mean of \code{var}.
  \item \code{dichBy = "value"} (or \code{dichBy = "v"}) splits \code{var} into two groups at a specific value (see \code{dichVal}).
  }}

\item{dichVal}{numeric, indicates a value where \code{var} is dichotomized when \code{dichBy = "value"}.
\emph{Note that \code{dichVal} is inclusive}, i.e. \code{dichVal = 10} will split \code{var}
into one group with values from lowest to 10 and another group with values greater
than 10.}

\item{asNum}{logical, if \code{TRUE}, return value will be numeric, not a factor.}
}
\value{
A dichotomized factor (or numeric, if \code{asNum = TRUE}) variable (0/1-coded).
}
\description{
Dichotomizes variables into dummy variables (0/1). Dichotomization is
               either done by median, mean or a specific value (see \code{dichBy}).
}
\examples{
data(efc)
summary(efc$c12hour)
table(dicho(efc$c12hour))
table(dicho(efc$c12hour, "mean"))
table(dicho(efc$c12hour, "value", 30))
}

