% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjp.glm}
\alias{sjp.glm}
\title{Plot odds ratios (forest plots)}
\usage{
sjp.glm(fit, sortOdds = TRUE, title = NULL, axisLabels.y = NULL,
  axisTitle.x = "Odds Ratios", axisLimits = NULL, breakTitleAt = 50,
  breakLabelsAt = 25, gridBreaksAt = 0.5, transformTicks = FALSE,
  type = "dots", geom.size = 3, geom.colors = "Set1",
  hideErrorBars = FALSE, interceptLineType = 2,
  interceptLineColor = "grey70", coord.flip = TRUE, showIntercept = FALSE,
  showAxisLabels.y = TRUE, showValueLabels = TRUE, labelDigits = 2,
  showPValueLabels = TRUE, showModelSummary = TRUE, facet.grid = TRUE,
  show.se = FALSE, printPlot = TRUE)
}
\arguments{
\item{fit}{The fitted model of a logistic regression (or any other \code{\link{glm}}-object).}

\item{sortOdds}{If \code{TRUE} (default), the odds ratios are ordered according their OR value from highest first
to lowest last. Use \code{FALSE} if you don't want to change the order of the predictors.}

\item{title}{Diagram's title as string.
Example: \code{title=c("my title")}}

\item{axisLabels.y}{Labels of the predictor variables (independent vars, odds) that are used for labelling the
axis. Passed as vector of strings.
Example: \code{axisLabels.y=c("Label1", "Label2", "Label3")}
Note: If you use the \code{\link{sji.SPSS}} function and the \code{\link{sji.getValueLabels}} function, you receive a
\code{list} object with label string. The labels may also be passed as list object. They will be unlisted and
converted to character vector automatically.}

\item{axisTitle.x}{A label ("title") for the x axis.}

\item{axisLimits}{Defines the range of the axis where the beta coefficients and their confidence intervalls
are drawn. By default, the limits range from the lowest confidence interval to the highest one, so
the diagram has maximum zoom. Use your own values as 2-value-vector, for instance: \code{limits=c(-0.8,0.8)}.}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is 0.5}

\item{transformTicks}{if \code{TRUE}, the grid bars have exponential distances (equidistant), i.e. they
visually have the same distance from one grid bar to the next. Default is \code{FALSE} which
means that grids are plotted on every \code{gridBreaksAt}'s position, thus the grid bars
become narrower with higher odds ratio values.}

\item{type}{type of plot. Use one of following:
\itemize{
  \item \code{"dots"} or \code{"or"} (default) for odds ratios (forest plot)
  \item \code{"bars"} for odds ratios as bar plot
  \item \code{"prob"} or \code{"pc"} to plot probability curves of coefficients (model terms). Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot.
}}

\item{geom.size}{size resp. width of the geoms (bar width or point size, depending on \code{type} parameter).}

\item{geom.colors}{User defined color palette for geoms. Must either be vector with two color values
or a specific color palette code (see below).
\itemize{
  \item If not specified, the diverging \code{"Paired"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
}
Else specify your own color values as vector (e.g. \code{geom.colors=c("#f00000", "#00ff00")}).}

\item{hideErrorBars}{If \code{TRUE}, the error bars that indicate the confidence intervals of the odds ratios are not
shown. Only applies if parameter \code{type} is \code{bars}. Default value is \code{FALSE}.}

\item{interceptLineType}{The linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{The color of the intercept line. Default value is \code{"grey70"}.}

\item{coord.flip}{If \code{TRUE} (default), predictors are plotted on the left y-axis and estimate
values are plotted on the x-axis.}

\item{showIntercept}{If \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}. Please note that due to exp-transformation of
estimates, the intercept in some cases can not be calculated, thus the
function call is interrupted and no plot printed.}

\item{showAxisLabels.y}{Whether odds names (predictor labels) should be shown or not.}

\item{showValueLabels}{Whether the beta and standardized beta values should be plotted
to each dot or not.}

\item{labelDigits}{The amount of digits for rounding the estimations (see \code{showValueLabels}).
Default is 2, i.e. estimators have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not.}

\item{showModelSummary}{If \code{TRUE} (default), a summary of the regression model with
Intercept, R-square, F-Test and AIC-value is printed to the lower right corner
of the diagram.}

\item{facet.grid}{\code{TRUE} when each plot should be plotted separately instead of
an integrated (faceted) single graph. Only applies, if \code{type="prob"}.}

\item{show.se}{Use \code{TRUE} to plot (depending on \code{type}) the standard
error for probability curves.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Invisibly) returns a structure with following elements:
        \itemize{
         \item \code{plot}: ggplot-object with the complete plot
         \item \code{mydf}: data frame that was used for setting up the ggplot-object
         \item \code{mydf.mp}: a list of data frames with the data for metric predictors (terms of type \code{numeric}), which will be plotted if \code{showContPredPlots} is \code{TRUE}
         \item \code{plot.mp}: a list of ggplot-objects with plots of metric predictors (terms of type \code{numeric}), which will be plotted if \code{showContPredPlots} is \code{TRUE}
        }
}
\description{
Plot odds ratios (exponentiated coefficients) with confidence intervalls as bar chart or dot plot
}
\note{
Based on the script from \href{http://www.surefoss.org/dataanalysis/plotting-odds-ratios-aka-a-forrestplot-with-ggplot2/}{surefoss}
}
\examples{
# prepare dichotomous dependent variable
y <- ifelse(swiss$Fertility<median(swiss$Fertility), 0, 1)

# fit model
fitOR <- glm(y ~ swiss$Education + swiss$Examination + swiss$Infant.Mortality + swiss$Catholic,
             family=binomial(link="logit"))

# print Odds Ratios as dots
sjp.glm(fitOR)

# print Odds Ratios as bars
sjp.glm(fitOR, type="bars")


# -------------------------------
# Predictors for negative impact
# of care. Data from the EUROFAMCARE
# sample dataset
# -------------------------------
data(efc)
# retrieve predictor variable labels
labs <- sji.getVariableLabels(efc)
predlab <- c(labs[['c161sex']],
             paste0(labs[['e42dep']], " (slightly)"),
             paste0(labs[['e42dep']], " (moderate)"),
             paste0(labs[['e42dep']], " (severely)"),
             labs[['barthtot']],
             paste0(labs[['c172code']], " (mid)"),
             paste0(labs[['c172code']], " (high)"))
# create binary response
y <- ifelse(efc$neg_c_7 < median(na.omit(efc$neg_c_7)), 0, 1)
# create dummy variables for educational status
edu.mid <- ifelse(efc$c172code == 2, 1, 0)
edu.high <- ifelse(efc$c172code == 3, 1, 0)
# create data frame for fitted model
mydf <- na.omit(data.frame(y = as.factor(y),
                           sex = as.factor(efc$c161sex),
                           dep = as.factor(efc$e42dep),
                           barthel = as.numeric(efc$barthtot),
                           edu.mid = as.factor(edu.mid),
                           edu.hi = as.factor(edu.high)))
# fit model
fit <- glm(y ~., data = mydf, family = binomial(link = "logit"))
# plot odds
sjp.glm(fit,
        title = labs[['neg_c_7']],
        axisLabels.y = predlab)

# plot probability curves of coefficients
sjp.glm(fit,
        title = labs[['neg_c_7']],
        axisLabels.y = predlab,
        type = "prob")
}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjp.glm/}{sjPlot manual: sjp.glm}
             \item \code{\link{sjp.glmm}}
             \item \code{\link{sjp.glm.ma}}
             \item \code{\link{sjt.glm}}
             }
}

