# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Expected value DR
#' @description This function computes the expected value of a drift process.
#' @param omega A \code{double} corresponding to variance of drift.
#' @param n_ts An \code{int} indicating the length of the time series.
#' @return A \code{vec} containing the expected value of the drift.
#' @keywords internal
e_drift <- function(omega, n_ts) {
    .Call('_simts_e_drift', PACKAGE = 'simts', omega, n_ts)
}

#' @title Second moment DR
#' @description This function computes the second moment of a drift process.
#' @param omega A \code{double} corresponding to variance of drift.
#' @param n_ts An \code{int} indicating the length of the time series.
#' @return A \code{vec} containing the second moment of the drift.
#' @keywords internal
m2_drift <- function(omega, n_ts) {
    .Call('_simts_m2_drift', PACKAGE = 'simts', omega, n_ts)
}

#' @title Variance DR
#' @description This function computes the variance of a drift process.
#' @param omega A \code{double} corresponding to variance of drift.
#' @param n_ts An \code{int} indicating the length of the time series.
#' @return A \code{vec} containing the variance of the drift.
#' @keywords internal
var_drift <- function(omega, n_ts) {
    .Call('_simts_var_drift', PACKAGE = 'simts', omega, n_ts)
}

#' ARMA Adapter to ARMA to WV Process function
#' 
#' Molds the data so that it works with the arma_to_wv function.
#' @param theta A \code{vec} that contains all the parameter estimates.
#' @param p     A \code{int} that indicates the number of AR coefficients
#' @param q     A \code{int} that indicates the number of MA coefficients.
#' @template misc/tau
#' @return A \code{vec} containing the ARMA to WV results
#' @details 
#' The data conversion is more or less a rearrangement of values without using the obj desc. 
#' @keywords internal
#' @backref src/analytical_matrix_derivatives.cpp
#' @backref src/analytical_matrix_derivatives.h
#' @template author/jjb
arma_adapter <- function(theta, p, q, tau) {
    .Call('_simts_arma_adapter', PACKAGE = 'simts', theta, p, q, tau)
}

#' Calculates the Jacobian for the ARMA process
#' 
#' Take the numerical derivative for the first derivative of an ARMA using the 2 point rule.
#' @inheritParams arma_adapter
#' @return A \code{mat} that returns the first numerical derivative of the ARMA process.
#' @keywords internal
#' @backref src/analytical_matrix_derivatives.cpp
#' @backref src/analytical_matrix_derivatives.h
#' @template author/jjb
jacobian_arma <- function(theta, p, q, tau) {
    .Call('_simts_jacobian_arma', PACKAGE = 'simts', theta, p, q, tau)
}

#' Analytic D matrix for ARMA(1,1) process
#' 
#' Obtain the first derivative of the ARMA(1,1) process. 
#' @param phi    A \code{double} corresponding to the phi coefficient of an ARMA(1,1) process.
#' @param theta  A \code{double} corresponding to the theta coefficient of an ARMA(1,1) process.
#' @param sigma2 A \code{double} corresponding to the error term of an ARMA(1,1) process.
#' @template misc/tau
#' @return A \code{matrix} with:
#' \itemize{
#' \item The \strong{first} column containing the partial derivative with respect to \eqn{\phi}{phi};
#' \item The \strong{second} column containing the partial derivative with respect to \eqn{\theta}{theta};
#' \item The \strong{third} column contains the partial derivative with respect to \eqn{\sigma ^2}{sigma^2}.
#' }
#' @template deriv_wv/1st/deriv1_arma11
#' @template author/jjb
deriv_arma11 <- function(phi, theta, sigma2, tau) {
    .Call('_simts_deriv_arma11', PACKAGE = 'simts', phi, theta, sigma2, tau)
}

#' Analytic D matrix for ARMA(1,1) process
#' 
#' Obtain the second derivative of the ARMA(1,1) process. 
#' @param phi    A \code{double} corresponding to the phi coefficient of an ARMA(1,1) process.
#' @param theta  A \code{double} corresponding to the theta coefficient of an ARMA(1,1) process.
#' @param sigma2 A \code{double} corresponding to the error term of an ARMA(1,1) process.
#' @template misc/tau
#' @return A \code{matrix} with:
#' \itemize{
#' \item The \strong{first} column containing the second partial derivative with respect to \eqn{\phi}{phi};
#' \item The \strong{second} column containing the second partial derivative with respect to \eqn{\theta}{theta};
#' \item The \strong{third} column contains the second partial derivative with respect to \eqn{\sigma ^2}{sigma^2}.
#' \item The \strong{fourth} column contains the partial derivative with respect to \eqn{\phi}{phi} and \eqn{\theta}{theta}.
#' \item The \strong{fiveth} column contains the partial derivative with respect to \eqn{\sigma ^2}{sigma^2} and \eqn{\phi}{phi}.
#' \item The \strong{sixth} column contains the partial derivative with respect to \eqn{\sigma ^2}{sigma^2} and \eqn{\theta}{theta}.
#' }
#' @template deriv_wv/2nd/deriv2_arma11
#' @template author/jjb
deriv_2nd_arma11 <- function(phi, theta, sigma2, tau) {
    .Call('_simts_deriv_2nd_arma11', PACKAGE = 'simts', phi, theta, sigma2, tau)
}

#' Analytic D matrix for AR(1) process
#' 
#' Obtain the first derivative of the AR(1) process. 
#' @param phi    A \code{double} corresponding to the phi coefficient of an AR(1) process.
#' @param sigma2 A \code{double} corresponding to the error term of an AR(1) process.
#' @template misc/tau
#' @return A \code{matrix} with the first column containing the partial derivative with respect to \eqn{\phi}{phi} 
#' and the second column contains the partial derivative with respect to \eqn{\sigma ^2}{sigma^2}
#' @template deriv_wv/1st/deriv1_ar1
#' @template author/jjb
deriv_ar1 <- function(phi, sigma2, tau) {
    .Call('_simts_deriv_ar1', PACKAGE = 'simts', phi, sigma2, tau)
}

#' Analytic second derivative matrix for AR(1) process
#' 
#' Calculates the second derivative for the AR(1) process and places it into a matrix form.
#' The matrix form in this case is for convenience of the calculation. 
#' @param phi    A \code{double} corresponding to the phi coefficient of an AR(1) process.
#' @param sigma2 A \code{double} corresponding to the error term of an AR(1) process.
#' @template misc/tau
#' @return A \code{matrix} with the first column containing the
#'  second partial derivative with respect to \eqn{\phi}{phi} and
#'   the second column contains the second partial derivative with 
#'   respect to \eqn{\sigma ^2}{sigma^2}
#' @template deriv_wv/2nd/deriv2_ar1
#' @template author/jjb
deriv_2nd_ar1 <- function(phi, sigma2, tau) {
    .Call('_simts_deriv_2nd_ar1', PACKAGE = 'simts', phi, sigma2, tau)
}

#' Analytic D matrix for MA(1) process
#' 
#' Obtain the first derivative of the MA(1) process. 
#' @param theta  A \code{double} corresponding to the theta coefficient of an MA(1) process.
#' @param sigma2 A \code{double} corresponding to the error term of an MA(1) process.
#' @template misc/tau
#' @return A \code{matrix} with the first column containing the partial derivative with respect to \eqn{\theta}{theta}
#'  and the second column contains the partial derivative with respect to \eqn{\sigma ^2}{sigma^2}
#' @template deriv_wv/1st/deriv1_ma1
#' @template author/jjb
deriv_ma1 <- function(theta, sigma2, tau) {
    .Call('_simts_deriv_ma1', PACKAGE = 'simts', theta, sigma2, tau)
}

#' Analytic second derivative for MA(1) process
#' 
#' To ease a later calculation, we place the result into a matrix structure. 
#' @param theta  A \code{double} corresponding to the theta coefficient of an MA(1) process.
#' @param sigma2 A \code{double} corresponding to the error term of an MA(1) process.
#' @template misc/tau
#' @return A \code{matrix} with the first column containing the second partial derivative with respect to \eqn{\theta}{theta},
#'  the second column contains the partial derivative with respect to \eqn{\theta}{theta} and \eqn{\sigma ^2}{sigma^2},
#'  and lastly we have the second partial derivative with respect to \eqn{\sigma ^2}{sigma^2}.
#' @template deriv_wv/2nd/deriv2_ma1
#' @template author/jjb
deriv_2nd_ma1 <- function(theta, sigma2, tau) {
    .Call('_simts_deriv_2nd_ma1', PACKAGE = 'simts', theta, sigma2, tau)
}

#' Analytic D matrix for Drift (DR) Process
#' 
#' Obtain the first derivative of the Drift (DR) process. 
#' @param omega A \code{double} that is the slope of the drift.
#' @template misc/tau
#' @return A \code{matrix} with the first column containing the partial derivative 
#' with respect to \eqn{\omega}{omega}.
#' @template deriv_wv/1st/deriv1_dr
#' @template author/jjb
deriv_dr <- function(omega, tau) {
    .Call('_simts_deriv_dr', PACKAGE = 'simts', omega, tau)
}

#' Analytic second derivative matrix for drift process
#' 
#' To ease a later calculation, we place the result into a matrix structure. 
#' @template misc/tau
#' @return A \code{matrix} with the first column containing 
#' the second partial derivative with respect to \eqn{\omega}{omega}.
#' @template author/jjb
deriv_2nd_dr <- function(tau) {
    .Call('_simts_deriv_2nd_dr', PACKAGE = 'simts', tau)
}

#' Analytic D matrix for Quantization Noise (QN) Process
#' 
#' Obtain the first derivative of the Quantization Noise (QN) process. 
#' @template misc/tau
#' @return A \code{matrix} with the first column containing 
#' the partial derivative with respect to \eqn{Q^2}{Q^2}.
#' @template deriv_wv/1st/deriv1_qn
#' @template author/jjb
deriv_qn <- function(tau) {
    .Call('_simts_deriv_qn', PACKAGE = 'simts', tau)
}

#' Analytic D matrix Random Walk (RW) Process
#' 
#' Obtain the first derivative of the Random Walk (RW) process. 
#' @template misc/tau
#' @return A \code{matrix} with the first column containing
#'  the partial derivative with respect to \eqn{\gamma^2}{gamma^2}.
#' @template deriv_wv/1st/deriv1_rw
#' @template author/jjb
deriv_rw <- function(tau) {
    .Call('_simts_deriv_rw', PACKAGE = 'simts', tau)
}

#' Analytic D Matrix for a Gaussian White Noise (WN) Process
#' 
#' Obtain the first derivative of the Gaussian White Noise (WN) process. 
#' @template misc/tau
#' @return A \code{matrix} with the first column containing 
#' the partial derivative with respect to \eqn{\sigma^2}{sigma^2}.
#' @template deriv_wv/1st/deriv1_wn
#' @template author/jjb
deriv_wn <- function(tau) {
    .Call('_simts_deriv_wn', PACKAGE = 'simts', tau)
}

#' Analytic D matrix of Processes
#' 
#' This function computes each process to WV (haar) in a given model.
#' @param theta   A \code{vec} containing the list of estimated parameters.
#' @param desc    A \code{vector<string>} containing a list of descriptors.
#' @param objdesc A \code{field<vec>} containing a list of object descriptors.
#' @template misc/tau
#' @return A \code{matrix} with the process derivatives going down the column
#' @details
#' Function returns the matrix effectively known as "D"
#' @template author/jjb
derivative_first_matrix <- function(theta, desc, objdesc, tau) {
    .Call('_simts_derivative_first_matrix', PACKAGE = 'simts', theta, desc, objdesc, tau)
}

#' Analytic D matrix of Processes
#' 
#' This function computes each process to WV (haar) in a given model.
#' @param theta     A \code{vec} containing the list of estimated parameters.
#' @param desc      A \code{vector<string>} containing a list of descriptors.
#' @param objdesc   A \code{field<vec>} containing a list of object descriptors.
#' @template misc/tau
#' @param omegadiff A \code{vec} that contains the result of Omega * (wv_empir - wv_theo)
#' @return A \code{matrix} with the process derivatives going down the column
#' @details
#' Function returns the matrix effectively known as "D"
#' @template author/jjb
#' @keywords internal
D_matrix <- function(theta, desc, objdesc, tau, omegadiff) {
    .Call('_simts_D_matrix', PACKAGE = 'simts', theta, desc, objdesc, tau, omegadiff)
}

#' @title Hook into R's ARIMA function
#' @description Uses R's ARIMA function to obtain CSS values for starting condition
#' @param data A \code{vec} of data.
#' @param params A \code{vec} of the ARMA parameters
#' @return A \code{vec} containing the CSS of the ARMA parameters.
#' @keywords internal
Rcpp_ARIMA <- function(data, params) {
    .Call('_simts_Rcpp_ARIMA', PACKAGE = 'simts', data, params)
}

#' Sort Matrix by Column
#' 
#' Sorts a given matrix by a specific column while retain the elements in each row.
#' 
#' @param x   A \code{matrix} to sort
#' @param col A \code{int} that indicates the column the matrix should sort by.
#' @details 
#' The functional difference between armadillo's sort() and sort_mat() is straight forward.
#' sort() will sort each column without respect to the rows. 
#' Using sort_matrix will sort only 1 column and retain the other elements to be in the same row.
#' @return The matrix sorted by values in the specified column.
#' @keywords internal
sort_mat <- function(x, col) {
    .Call('_simts_sort_mat', PACKAGE = 'simts', x, col)
}

#' @title Reverse Subset Column
#' @description 
#' Subsets the column by going from high indices to low (the reverse of the supported practice)
#' @param x     A \code{matrix} of dimensions M x N
#' @param start A \code{unsigned int} that indicates the starting column.
#' @param end   A \code{unsigned int} that indicates the ending column.
#' @return x A \code{matrix} with matrix rows displayed in reverse order
#' @details Consider a vector x=[[1,2],[3,4]].
#' By setting \code{start=1} and \code{end=0}, the function would output x=[[2,1],[4,1]].
#' Start and end must be valid C++ matrix locations. (e.g. matrix cols start at 0 and not 1)
#' @author JJB
#' @keywords internal
rev_col_subset <- function(x, start, end) {
    .Call('_simts_rev_col_subset', PACKAGE = 'simts', x, start, end)
}

#' @title Reverse Subset Row
#' @description Subsets the row by going from high indices to low (the reverse of the supported practice)
#' @param x      A \code{matrix} of dimensions M x N
#' @param start  A \code{unsigned int} that indicates the starting row.
#' @param end    A \code{unsigned int} that indicates the ending row.
#' @return x A \code{matrix} with matrix rows displayed in reversed order
#' @details Consider a vector x=[[1,2],[3,4]], the function would output x=[[3,4],[1,2]].
#' Start and end must be valid C++ matrix locations. (e.g. matrix rows start at 0 and not 1)
#' @author JJB
#' @keywords internal
rev_row_subset <- function(x, start, end) {
    .Call('_simts_rev_row_subset', PACKAGE = 'simts', x, start, end)
}

#' @title Reverse Armadillo Vector
#' @description Reverses the order of an Armadillo Vector
#' @usage reverse_vec(x)
#' @param x A \code{column vector} of length N
#' @return x A \code{column vector} with its contents reversed.
#' @details Consider a vector x=[1,2,3,4,5], the function would output x=[5,4,3,2,1].
#' @author JJB
#' @keywords internal
reverse_vec <- function(x) {
    .Call('_simts_reverse_vec', PACKAGE = 'simts', x)
}

#' @title Transform an Armadillo field<vec> to a matrix
#' @description Unlists vectors in a field and places them into a matrix
#' @param x A \code{field<vec>}.
#' @return A \code{mat} containing the field elements within a column.
#' @author JJB
#' @keywords internal
field_to_matrix <- function(x) {
    .Call('_simts_field_to_matrix', PACKAGE = 'simts', x)
}

#' @title Accumulation of Armadillo field<vec>
#' @description Sums vectors in a field into a single variable.
#' @param x A \code{field<vec>}.
#' @return An \code{mat} containing the field elements within a column.
#' @author JJB
#' @keywords internal
sum_field_vec <- function(x) {
    .Call('_simts_sum_field_vec', PACKAGE = 'simts', x)
}

#' @title Build List of Unique Models
#' @description Creates a set containing unique strings. 
#' @param combs A \code{mat} that is a binary matrix (0,1) containing the combinations of different variables.
#' @param x A \code{vec<string>} that contains a list of model descriptors.
#' @return A \code{set<string>} that contains the list of unique models.
#' @keywords internal
build_model_set <- function(combs, x) {
    .Call('_simts_build_model_set', PACKAGE = 'simts', combs, x)
}

#' Set the RNG Seed from within Rcpp
#' 
#' Within Rcpp, one can set the R session seed without triggering
#' the CRAN rng modifier check. 
#' @param seed A \code{unsigned int} that is the seed one wishes to use. 
#' @return A set RNG scope.
#' @keywords internal
set_seed <- function(seed) {
    invisible(.Call('_simts_set_seed', PACKAGE = 'simts', seed))
}

#' @title Conversion function of Vector to Set
#' @description Converts a vector into a set
#' @return A \code{set<vector<string>>} that contains the list of unique models.
#' @keywords internal
vector_to_set <- function(model_str) {
    .Call('_simts_vector_to_set', PACKAGE = 'simts', model_str)
}

#' @title Find the Common Denominator of the Models
#' @description Determines the common denominator among models
#' @param x A \code{vector< vector<string> >} that contains all possible models under consideration
#' @return A \code{vector<string>} that contains the terms of the common denominator of all models
#' @keywords internal
find_full_model <- function(x) {
    .Call('_simts_find_full_model', PACKAGE = 'simts', x)
}

#' @title Find the Rank Models result
#' @description Provides the core material to create an S3 object for rank.models
#' @param data A \code{vec} of data.
#' @param model_str A \code{vector<vector<string>>} that gives a list of models to test.
#' @param full_model A \code{vector<string>} that contains the largest / full model.
#' @param alpha A \code{double} that indicates the alpha level for CIs.
#' @param compute_v A \code{string} indicating the type of V matrix to generate
#' @param model_type A \code{string} that describes the model generation / transformation: 'ssm' or 'imu'
#' @param K A \code{int} that controls how many times the GMWM is run. 
#' @param H A \code{int} that controls how many bootstraps occur.
#' @param G A \code{int} that controls how many guesses occur.
#' @param robust A \code{bool} that indicates whether to use classical or robust wavelet variance.
#' @param eff A \code{double} that indicates the efficiency to use.
#' @param bs_optimism A \code{bool} that indicates whether the model selection score should be calculated with bootstrap or asymptotics.
#' @param seed A \code{unsigned int} that is the seed one wishes to use. 
#' @return A \code{field<field<field<mat>>>} that contains the model score matrix and the best GMWM model object.
#' @keywords internal
rank_models_cpp <- function(data, model_str, full_model, alpha, compute_v, model_type, K, H, G, robust, eff, bs_optimism, seed) {
    .Call('_simts_rank_models_cpp', PACKAGE = 'simts', data, model_str, full_model, alpha, compute_v, model_type, K, H, G, robust, eff, bs_optimism, seed)
}

#' @title Find the auto imu result
#' @description Provides the core material to create an S3 object for auto.imu
#' @param data A \code{mat} containing multiple columns of independent data with the same number of observations.
#' @param full_model A \code{vector<string>} that contains the largest / full model.
#' @param alpha A \code{double} that indicates the alpha level for CIs.
#' @param compute_v A \code{string} indicating the type of V matrix to generate
#' @param model_type A \code{string} that describes the model generation / transformation: 'ssm' or 'imu'
#' @param K A \code{int} that controls how many times the GMWM is run. 
#' @param H A \code{int} that controls how many bootstraps occur.
#' @param G A \code{int} that controls how many guesses occur.
#' @param robust A \code{bool} that indicates whether to use classical or robust wavelet variance.
#' @param eff A \code{double} that indicates the efficiency to use.
#' @param bs_optimism A \code{bool} that indicates whether the model selection score should be calculated with bootstrap or asymptotics.
#' @param seed A \code{unsigned int} that is the seed one wishes to use. 
#' @return A \code{field<field<field<mat>>>} that contains the model score matrix and the best GMWM model object.
#' @keywords internal
auto_imu_cpp <- function(data, combs, full_model, alpha, compute_v, model_type, K, H, G, robust, eff, bs_optimism, seed) {
    .Call('_simts_auto_imu_cpp', PACKAGE = 'simts', data, combs, full_model, alpha, compute_v, model_type, K, H, G, robust, eff, bs_optimism, seed)
}

#' @title Bootstrap for Matrix V
#' @description Using the bootstrap approach, we simulate a model based on user supplied parameters, obtain the wavelet variance, and then V.
#' @param theta A \code{vector} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' Expand in detail...  
#' @author JJB
#' @keywords internal
cov_bootstrapper <- function(theta, desc, objdesc, N, robust, eff, H, diagonal_matrix) {
    .Call('_simts_cov_bootstrapper', PACKAGE = 'simts', theta, desc, objdesc, N, robust, eff, H, diagonal_matrix)
}

#' @title Bootstrap for Optimism
#' @description Using the bootstrap approach, we simulate a model based on user supplied parameters, obtain the wavelet variance, and then V.
#' @param theta A \code{vector} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' Expand in detail...  
#' @author JJB
#' @keywords internal
optimism_bootstrapper <- function(theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H) {
    .Call('_simts_optimism_bootstrapper', PACKAGE = 'simts', theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H)
}

#' @title Bootstrap for Optimism and GoF
#' @description Using the bootstrap approach, we simulate a model based on user supplied parameters, obtain the wavelet variance, and then V.
#' @param theta A \code{vector} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @param scales A \code{vec} containing the scales of the process.
#' @param model_type A \code{string} containing the model type either: SSM or IMU
#' @param N A \code{int} indicating how long the integer is. 
#' @param robust A \code{bool} indicating robust (T) or classical (F).
#' @param eff A \code{double} that handles efficiency.
#' @param H A \code{int} that indicates how many bootstraps should be obtained.
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' Expand in detail...  
#' @author JJB
#' @keywords internal
opt_n_gof_bootstrapper <- function(theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H) {
    .Call('_simts_opt_n_gof_bootstrapper', PACKAGE = 'simts', theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H)
}

#' @title Bootstrap for Standard Deviations of Theta Estimates
#' @description Using the bootstrap approach, we simulate a model based on user supplied parameters
#' @param theta A \code{vector} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' Expand in detail...  
#' @author JJB
#' @keywords internal
gmwm_sd_bootstrapper <- function(theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H) {
    .Call('_simts_gmwm_sd_bootstrapper', PACKAGE = 'simts', theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H)
}

#' @title Generate the Confidence Interval for GOF Bootstrapped
#' @description yaya
#' @param obj A \code{double} containing the objective value of the solution.
#' @param obj_boot A \code{vec} containing the objective values obtained while bootstrapping under Theta_hat.
#' @param B An \code{int} indicating how many times the bootstrapper should be run.
#' @param alpha A \code{double} indicating the amount of confidence for CI
#' @return A \code{vec} that has the alpha/2.0 quantile and then the 1-alpha/2.0 quantile. 
#' @keywords internal
boot_pval_gof <- function(obj, obj_boot, B = 1000L, alpha = 0.05) {
    .Call('_simts_boot_pval_gof', PACKAGE = 'simts', obj, obj_boot, B, alpha)
}

#' @title Bootstrap for Estimating Both Theta and Theta SD
#' @description Using the bootstrap approach, we simulate a model based on user supplied parameters, obtain the wavelet variance, and then V.
#' @param theta A \code{vector} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' Expand in detail...  
#' @author JJB
#' @keywords internal
gmwm_param_bootstrapper <- function(theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H) {
    .Call('_simts_gmwm_param_bootstrapper', PACKAGE = 'simts', theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H)
}

#' @title Bootstrap for Everything!
#' @description Using the bootstrap approach, we simulate a model based on user supplied parameters, obtain the wavelet variance, and then V.
#' @param theta A \code{vector} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' Expand in detail...  
#' @author JJB
#' @keywords internal
all_bootstrapper <- function(theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H) {
    .Call('_simts_all_bootstrapper', PACKAGE = 'simts', theta, desc, objdesc, scales, model_type, N, robust, eff, alpha, H)
}

#' @title Absolute Value or Modulus of a Complex Number.
#' @description Computes the value of the Modulus.
#' @param x A \code{cx_vec}. 
#' @return A \code{vec} containing the modulus for each element.
#' @details Consider a complex number defined as: \eqn{z = x + i y} with real \eqn{x} and \eqn{y},
#' The modulus is defined as: \eqn{r = Mod(z) = \sqrt{(x^2 + y^2)}}
#' @keywords internal
Mod_cpp <- function(x) {
    .Call('_simts_Mod_cpp', PACKAGE = 'simts', x)
}

#' @title Computes the (MODWT) wavelet covariance matrix
#' @description Calculates the (MODWT) wavelet covariance matrix
#' @param signal_modwt A \code{field<vec>} that contains the modwt decomposition.
#' @param nb_level A \code{integer} that contains the level of decomposition J.
#' @param compute_v A \code{string} that indicates what kind of matrix should be created. Possible options: "diag" or "none"
#' @param robust A \code{boolean} that triggers the use of the robust estimate.
#' @param eff A \code{double} that indicates the efficiency as it relates to an MLE.
#' @return A \code{field<mat>} containing the covariance matrix.
#' @keywords internal
compute_cov_cpp <- function(signal_modwt, nb_level, compute_v = "diag", robust = TRUE, eff = 0.6) {
    .Call('_simts_compute_cov_cpp', PACKAGE = 'simts', signal_modwt, nb_level, compute_v, robust, eff)
}

#' @title Computes the (MODWT) wavelet covariance matrix using Chi-square confidence interval bounds
#' @description Calculates the (MODWT) wavelet covariance matrix using Chi-square confidence interval bounds
#' @param ci_hi A \code{vec} that contains the upper confidence interval points.
#' @param ci_lo A \code{vec} that contains the lower confidence interval points.
#' @return A diagonal matrix.
#' @keywords internal
fast_cov_cpp <- function(ci_hi, ci_lo) {
    .Call('_simts_fast_cov_cpp', PACKAGE = 'simts', ci_hi, ci_lo)
}

#' @title Discrete Wavelet Transform
#' @description Calculation of the coefficients for the discrete wavelet transformation. 
#' @param x           A \code{vector} with dimensions \eqn{N\times 1}{N x 1}. 
#' @param filter_name A \code{string} indicating the filter.
#' @param nlevels     An \code{integer}, \eqn{J}, indicating the level of the decomposition.
#' @param boundary    A \code{string} indicating the type of boundary method to use. Either \code{boundary="periodic"} or \code{"reflection"}.
#' @param brickwall   A \code{bool} indicating whether the a brick wall procedure should be applied to the coefficients.
#' @return y A \code{field<vec>} that contains the wavelet coefficients for each decomposition level
#' @details
#' Performs a level J decomposition of the time series using the pyramid algorithm
#' @author JJB
#' @keywords internal
dwt_cpp <- function(x, filter_name, nlevels, boundary, brickwall) {
    .Call('_simts_dwt_cpp', PACKAGE = 'simts', x, filter_name, nlevels, boundary, brickwall)
}

#' @title Maximum Overlap Discrete Wavelet Transform
#' @description 
#' Calculation of the coefficients for the discrete wavelet transformation
#' @inheritParams dwt_cpp
#' @return y A \code{field<vec>} that contains the wavelet coefficients for each decomposition level
#' @keywords internal
#' @details
#' Performs a level J decomposition of the time series using the pyramid algorithm.
#' Use this implementation to supply custom parameters instead of modwt(x),
#' which serves as a wrapper function.
#' @author JJB
#' @keywords internal
modwt_cpp <- function(x, filter_name, nlevels, boundary, brickwall) {
    .Call('_simts_modwt_cpp', PACKAGE = 'simts', x, filter_name, nlevels, boundary, brickwall)
}

#' @title Removal of Boundary Wavelet Coefficients
#' @description Removes the first n wavelet coefficients.
#' @param x           A \code{field<vec>} that contains the nlevel decomposition using either modwt or dwt.
#' @param wave_filter A \code{field<vec>} containing filter information. Only "haar" is implemented.
#' @param method      A \code{string} to describe the mode. Choose between "modwt" and "dwt"
#' @return A \code{field<vec>} with boundary modwt or dwt taken care of.
#' @keywords internal
#' @details 
#' The vectors are truncated by removing the first n wavelet coefficients. 
#' These vectors are then stored into the field that is returned.
#' Note: As a result, there are no NA's introduced and hence the na.omit is not needed.
brick_wall <- function(x, wave_filter, method) {
    .Call('_simts_brick_wall', PACKAGE = 'simts', x, wave_filter, method)
}

#' Generate a Gaussian White Noise Process (WN(\eqn{\sigma ^2}{sigma^2}))
#' 
#' Simulates a Gaussian White Noise Process with variance parameter \eqn{\sigma ^2}{sigma^2}.
#' @param N      An \code{integer} for signal length.
#' @param sigma2 A \code{double} that contains process variance.
#' @return wn A \code{vec} containing the white noise.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @template processes_defined/process_wn
#' @section Generation Algorithm:
#' To generate the Gaussian White Noise (WN) process, we first obtain the 
#' standard deviation from the variance by taking a square root. Then, we 
#' sample \eqn{N} times from a \eqn{N(0,\sigma ^2)}{N(0,sigma^2)} distribution.
#' @keywords internal
#' @export
gen_wn <- function(N, sigma2 = 1) {
    .Call('_simts_gen_wn', PACKAGE = 'simts', N, sigma2)
}

#' Generate a Sinusoidal Process given \eqn{\alpha^2}{alpha^2} and \eqn{\beta}{beta}.
#' 
#' Simulates a Sinusoidal Process Process with parameter \eqn{\alpha^2}{alpha^2}  and \eqn{\beta}{beta}
#' @param N      An \code{integer} for signal length.
#' @param alpha2 A \code{double} that contains the squared amplitude parameter alpha2.
#' @param beta A \code{double} that contains the angular frequency parameter beta.
#' @return sn A \code{vec} containing the sinusoidal process.
#' @section Generation Algorithm:
#' The function first generates a initial cycle oscillation at t=0 from a Uniform law with parameter a = 0 and b = 2 * pi 
#' and then compute the signal from its definition \deqn{X_t = \alpha \sin(\beta t + U)}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_sin <- function(N, alpha2 = 9e-04, beta = 6e-02, U = 1) {
    .Call('_simts_gen_sin', PACKAGE = 'simts', N, alpha2, beta, U)
}

#' Generate a Fractional Gaussian noise given \eqn{\sigma^2}{sigma^2} and \eqn{H}{H}.
#' 
#' Simulates a Fractional Gaussian noise given \eqn{\sigma^2} and \eqn{H}.
#' @param N      An \code{integer} for signal length.
#' @param sigma2 A \code{double}.
#' @param H A \code{double}.
#' @return fgn A \code{vec} containing the Fractional Gaussian noise process.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_fgn <- function(N, sigma2 = 1, H = 0.9) {
    .Call('_simts_gen_fgn', PACKAGE = 'simts', N, sigma2, H)
}

#' Generate a Power Law Process given \eqn{\sigma^2} and \eqn{d}.
#' 
#' Simulates a a Power Law Process given \eqn{\sigma^2} and \eqn{d}.
#' @param N An \code{integer} for signal length.
#' @param sigma2 A \code{double}.
#' @param d A \code{double}.
#' @return plp A \code{vec} containing the Power Law Process.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_powerlaw <- function(N, sigma2 = 1, d = 0.9) {
    .Call('_simts_gen_powerlaw', PACKAGE = 'simts', N, sigma2, d)
}

#' Ma function.
#' 
#' @param x A \code{double}.
#' @param alpha A \code{double}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
Ma_cpp <- function(x, alpha) {
    .Call('_simts_Ma_cpp', PACKAGE = 'simts', x, alpha)
}

#' Ma vectorized function.
#' 
#' @param x A \code{NumericVector}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
Ma_cpp_vec <- function(x, alpha) {
    .Call('_simts_Ma_cpp_vec', PACKAGE = 'simts', x, alpha)
}

#' Generate a Matern Process given \eqn{\sigma^2}, \eqn{\lambda} and \eqn{\alpha}.
#' 
#' Simulates a Matern Process given \eqn{\sigma^2}, \eqn{\lambda} and \eqn{\alpha}.
#' @param N An \code{integer} for signal length.
#' @param sigma2 A \code{double}.
#' @param lambda A \code{double}.
#' @param alpha A \code{double}.
#' @return mtp A \code{vec} containing the Matern Process.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_matern <- function(N, sigma2 = 1, lambda = 0.35, alpha = 0.9) {
    .Call('_simts_gen_matern', PACKAGE = 'simts', N, sigma2, lambda, alpha)
}

#' Generate a determinist vector returned by the matrix by vector product of matrix \eqn{X} and vector \eqn{\beta}.
#' 
#' Generate a determinist vector returned by the matrix by vector product of matrix \eqn{X} and vector \eqn{\beta}.
#' @param X A \code{Matrix}  with dimension n*p.
#' @param beta A \code{vector} with dimension p*1
#' @return mean_vec A \code{vec} containing the determinist vector.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_mean <- function(X, beta) {
    .Call('_simts_gen_mean', PACKAGE = 'simts', X, beta)
}

#' Generate a Drift Process
#' 
#' Simulates a Drift Process with a given slope, \eqn{\omega}.
#' @param N     An \code{integer} for signal length.
#' @param omega A \code{double} that contains drift slope
#' @return A \code{vec} containing the drift.
#' @template processes_defined/process_dr
#' @section Generation Algorithm:
#' To generate the Drift process, we first fill a \code{vector} with the \eqn{\omega}{omega} parameter.
#' After, we take the cumulative sum along the vector. 
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_dr <- function(N, omega = 5) {
    .Call('_simts_gen_dr', PACKAGE = 'simts', N, omega)
}

#' Generate a Quantisation Noise (QN) or Rounding Error Sequence
#' 
#' Simulates a QN sequence given \eqn{Q^2}.
#' @param N  An \code{integer} for signal length.
#' @param q2 A \code{double} that contains autocorrection.
#' @return A \code{vec} containing the QN process.
#' @keywords internal
#' @template processes_defined/process_qn
#' @section Generation Algorithm:
#' To generate the quantisation noise, we follow this recipe:
#' First, we generate using a random uniform distribution:
#' \deqn{U_k^*\sim U\left[ {0,1} \right]}{U_k^*~U[0,1]}
#' 
#' Then, we multiple the sequence by \eqn{\sqrt{12}}{sqrt(12)} so:
#' \deqn{{U_k} = \sqrt{12} U_k^*}{U_k = sqrt(12)*U_k^*}
#' 
#' Next, we find the derivative of \eqn{{U_k}}{U_k}
#' \deqn{{{\dot U}_k} = \frac{{{U_{k + \Delta t}} - {U_k}}}{{\Delta t}}}{U_k^. = (U_(k + (delta)t) - U_k)}
#'
#' In this case, we modify the derivative such that:
#' \eqn{{{\dot U}_k}\Delta t = {U_{k + \Delta t}} - {U_k}}{U_k^. * (delta)t = U_{k + (delta)*t} - U_k}
#'
#' Thus, we end up with:
#' \deqn{{x_k} = \sqrt Q {{\dot U}_k}\Delta t}{x_k = sqrt(Q)*U_k^.*(delta)t}
#' \deqn{{x_k} = \sqrt Q \left( {{U_{k + 1}} - {U_k}} \right)}{x_k = sqrt(Q)* (U_(k+1) - U_(k))}
#'
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @export
gen_qn <- function(N, q2 = .1) {
    .Call('_simts_gen_qn', PACKAGE = 'simts', N, q2)
}

#' Generate an Autoregressive Order 1 ( AR(1) ) sequence
#' 
#' Generate an Autoregressive Order 1 sequence given \eqn{\phi} and \eqn{\sigma^2}.
#' @param N      An \code{unsigned integer} for signal length.
#' @param phi    A \code{double} that contains autocorrection.
#' @param sigma2 A \code{double} that contains process variance.
#' @return A \code{vec} containing the AR(1) process.
#' @details
#' The function implements a way to generate the AR(1)'s \eqn{x_t}{x[t]} values \emph{without} calling the general ARMA function.
#' Thus, the function is able to generate values much faster than \code{\link{gen_arma}}.
#' @template processes_defined/process_ar1
#' @section Generation Algorithm:
#' The function first generates a vector of White Noise with length \eqn{N+1} using \code{\link{gen_wn}} and then obtains the
#' autoregressive values under the above process definition.
#' 
#' The \eqn{X_0}{X[0]} (first value of \eqn{X_t}{X[t]}) is discarded.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_ar1 <- function(N, phi = .3, sigma2 = 1) {
    .Call('_simts_gen_ar1', PACKAGE = 'simts', N, phi, sigma2)
}

#' Generate a Random Walk without Drift
#' 
#' Generates a random walk without drift.
#' @param N      An \code{integer} for signal length.
#' @param sigma2 A \code{double} that contains process variance.
#' @return grw A \code{vec} containing the random walk without drift.
#' @template processes_defined/process_rw
#' @section Generation Algorithm:
#' To generate we first obtain the standard deviation from the variance by taking a square root. Then, we 
#' sample \eqn{N} times from a \eqn{N(0,\sigma^2)}{N(0,sigma^2)} distribution. Lastly, we take the
#' cumulative sum over the vector. 
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_rw <- function(N, sigma2 = 1) {
    .Call('_simts_gen_rw', PACKAGE = 'simts', N, sigma2)
}

#' Generate an Moving Average Order 1 (MA(1)) Process
#' 
#' Generate an MA(1) Process given \eqn{\theta} and \eqn{\sigma^2}.
#' @param N      An \code{integer} for signal length.
#' @param theta  A \code{double} that contains moving average.
#' @param sigma2 A \code{double} that contains process variance.
#' @return A \code{vec} containing the MA(1) process.
#' @details
#' The function implements a way to generate the \eqn{x_t}{x[t]} values without calling the general ARMA function.
#' @template processes_defined/process_ma1
#' @section Generation Algorithm:
#' The function first generates a vector of white noise using \code{\link{gen_wn}} and then obtains the
#' MA values under the above equation. 
#' 
#' The \eqn{X_0}{X[0]} (first value of \eqn{X_t}{X[t]}) is discarded.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_ma1 <- function(N, theta = .3, sigma2 = 1) {
    .Call('_simts_gen_ma1', PACKAGE = 'simts', N, theta, sigma2)
}

#' Generate an ARMA(1,1) sequence
#' 
#' Generate an ARMA(1,1) sequence given \eqn{\phi}, \eqn{\theta}, and \eqn{\sigma^2}.
#' @param N      An \code{integer} for signal length.
#' @param phi    A \code{double} that contains autoregressive.
#' @param theta  A \code{double} that contains moving average.
#' @param sigma2 A \code{double} that contains process variance.
#' @return A \code{vec} containing the MA(1) process.
#' @details
#' The function implements a way to generate the \eqn{x_t}{x[t]} values without calling the general ARMA function.
#' @template processes_defined/process_arma11
#' @section Generation Algorithm:
#' The function first generates a vector of white noise using \code{gen_wn} and then obtains the
#' ARMA values under the above equation.
#' 
#' The \eqn{X_0}{X[0]} (first value of \eqn{X_t}{X[t]}) is discarded.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_arma11 <- function(N, phi = .1, theta = .3, sigma2 = 1) {
    .Call('_simts_gen_arma11', PACKAGE = 'simts', N, phi, theta, sigma2)
}

#' Generate Autoregressive Order \eqn{p} - Moving Average Order \eqn{q} (ARMA(\eqn{p},\eqn{q})) Model
#' 
#' Generate an ARMA(\eqn{p},\eqn{q}) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
#' @param N       An \code{integer} for signal length.
#' @param ar      A \code{vec} that contains the AR coefficients.
#' @param ma      A \code{vec} that contains the MA coefficients.
#' @param sigma2  A \code{double} that contains process variance.
#' @param n_start An \code{unsigned int} that indicates the amount of observations to be used for the burn in period. 
#' @return A \code{vec} that contains the generated observations.
#' @details
#' For \code{\link[=gen_ar1]{AR(1)}}, \code{\link[=gen_ma1]{MA(1)}}, and \code{\link[=gen_arma11]{ARMA(1,1)}} please use their functions if speed is important
#' as this function is designed to generate generic ARMA processes.
#' @template processes_defined/process_arma
#' @section Generation Algorithm: 
#' The innovations are generated from a normal distribution.
#' The \eqn{\sigma^2} parameter is indeed a variance parameter. 
#' This differs from R's use of the standard deviation, \eqn{\sigma}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_arma <- function(N, ar, ma, sigma2 = 1.5, n_start = 0L) {
    .Call('_simts_gen_arma', PACKAGE = 'simts', N, ar, ma, sigma2, n_start)
}

#' Generate Seasonal Autoregressive Order P - Moving Average Order Q (SARMA(p,q)x(P,Q)) Model
#' 
#' Generate an ARMA(P,Q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
#' @param N       An \code{integer} for signal length.
#' @param ar      A \code{vec} that contains the AR coefficients.
#' @param ma      A \code{vec} that contains the MA coefficients.
#' @param sar     A \code{vec} that contains the SAR coefficients.
#' @param sma     A \code{vec} that contains the SMA coefficients.
#' @param sigma2  A \code{double} that contains process variance.
#' @param s       An \code{integer} that contains a seasonal id. 
#' @param n_start An \code{unsigned int} that indicates the amount of observations to be used for the burn in period. 
#' @return A \code{vec} that contains the generated observations.
#' @details 
#' The innovations are generated from a normal distribution.
#' The \eqn{\sigma^2} parameter is indeed a variance parameter. 
#' This differs from R's use of the standard deviation, \eqn{\sigma}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_sarma <- function(N, ar, ma, sar, sma, sigma2 = 1.5, s = 12L, n_start = 0L) {
    .Call('_simts_gen_sarma', PACKAGE = 'simts', N, ar, ma, sar, sma, sigma2, s, n_start)
}

#' Generate Autoregressive Order p, Integrated d, Moving Average Order q (ARIMA(p,d,q)) Model
#' 
#' Generate an ARIMA(p,d,q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Integrated \eqn{d}{d}, Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
#' @param N       An \code{integer} for signal length.
#' @param ar      A \code{vec} that contains the AR coefficients.
#' @param d       An \code{integer} that indicates a difference.
#' @param ma      A \code{vec} that contains the MA coefficients.
#' @param sigma2  A \code{double} that contains process variance.
#' @param n_start An \code{unsigned int} that indicates the amount of observations to be used for the burn in period. 
#' @return A \code{vec} that contains the generated observations.
#' @details 
#' The innovations are generated from a normal distribution.
#' The \eqn{\sigma^2} parameter is indeed a variance parameter. 
#' This differs from R's use of the standard deviation, \eqn{\sigma}.
#' @section Warning:
#' Please note, this function will generate a sum of \eqn{N + d} number of observations,
#' where \eqn{d} denotes the number of differences necessary. 
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_arima <- function(N, ar, d, ma, sigma2 = 1.5, n_start = 0L) {
    .Call('_simts_gen_arima', PACKAGE = 'simts', N, ar, d, ma, sigma2, n_start)
}

#' Generate Seasonal Autoregressive Order P - Moving Average Order Q (SARMA(p,q)x(P,Q)) Model
#' 
#' Generate an ARMA(P,Q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
#' @param N       An \code{integer} for signal length.
#' @param ar      A \code{vec} that contains the AR coefficients.
#' @param d       An \code{integer} that indicates a non-seasonal difference.
#' @param ma      A \code{vec} that contains the MA coefficients.
#' @param sar     A \code{vec} that contains the SAR coefficients.
#' @param sd      An \code{integer} that indicates a seasonal difference.
#' @param sma     A \code{vec} that contains the SMA coefficients.
#' @param sigma2  A \code{double} that contains process variance.
#' @param s       An \code{integer} that contains a seasonal id. 
#' @param n_start An \code{unsigned int} that indicates the amount of observations to be used for the burn in period. 
#' @return A \code{vec} that contains the generated observations.
#' @details 
#' The innovations are generated from a normal distribution.
#' The \eqn{\sigma^2} parameter is indeed a variance parameter. 
#' This differs from R's use of the standard deviation, \eqn{\sigma}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_sarima <- function(N, ar, d, ma, sar, sd, sma, sigma2 = 1.5, s = 12L, n_start = 0L) {
    .Call('_simts_gen_sarima', PACKAGE = 'simts', N, ar, d, ma, sar, sd, sma, sigma2, s, n_start)
}

#' Generate Generic Seasonal Autoregressive Order P - Moving Average Order Q (SARMA(p,q)x(P,Q)) Model
#' 
#' Generate an ARMA(P,Q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
#' @param N            An \code{integer} for signal length.
#' @param theta_values A \code{vec} containing the parameters for (S)AR and (S)MA.
#' @param objdesc      A \code{vec} that contains the \code{\link{+.ts.model}}'s obj.desc field.
#' @param sigma2       A \code{double} that contains process variance.
#' @param n_start      An \code{unsigned int} that indicates the amount of observations to be used for the burn in period. 
#' @return A \code{vec} that contains the generated observations.
#' @details 
#' The innovations are generated from a normal distribution.
#' The \eqn{\sigma^2} parameter is indeed a variance parameter. 
#' This differs from R's use of the standard deviation, \eqn{\sigma}.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_generic_sarima <- function(N, theta_values, objdesc, sigma2 = 1.5, n_start = 0L) {
    .Call('_simts_gen_generic_sarima', PACKAGE = 'simts', N, theta_values, objdesc, sigma2, n_start)
}

#' Generate Time Series based on Model (Internal)
#' 
#' Create a time series process based on a supplied \code{ts.model}.
#' @param N       An \code{interger} containing the amount of observations for the time series.
#' @param theta   A \code{vec} containing the parameters to use to generate the model
#' @param desc    A \code{vector<string>} containing the different model types (AR1, WN, etc..)
#' @param objdesc A \code{field<vec>} contains the different model objects e.g. AR1 = c(1,1)
#' @return A \code{vec} that contains combined time series.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_model <- function(N, theta, desc, objdesc) {
    .Call('_simts_gen_model', PACKAGE = 'simts', N, theta, desc, objdesc)
}

#' Generate Latent Time Series based on Model (Internal)
#' 
#' Create a latent time series based on a supplied time series model.
#' @param N       An \code{interger} containing the amount of observations for the time series.
#' @param theta   A \code{vec} containing the parameters to use to generate the model.
#' @param desc    A \code{vector<string>} containing the different model types (AR1, WN, etc..).
#' @param objdesc A \code{field<vec>} containing the different model objects e.g. AR1 = c(1,1)
#' @return A \code{mat} containing data for each decomposed and combined time series.
#' @backref src/gen_process.cpp
#' @backref src/gen_process.h
#' @keywords internal
#' @export
gen_lts_cpp <- function(N, theta, desc, objdesc) {
    .Call('_simts_gen_lts_cpp', PACKAGE = 'simts', N, theta, desc, objdesc)
}

#' @title Optim loses NaN
#' @description This function takes numbers that are very small and sets them to the minimal tolerance for C++.
#' Doing this prevents NaN from entering the optim routine.
#' @param theta A \code{vec} that contains estimated GMWM theta values (untransformed).
#' @return A \code{vec} that contains safe theta values.
#' @keywords internal
code_zero <- function(theta) {
    .Call('_simts_code_zero', PACKAGE = 'simts', theta)
}

#' @title Engine for obtaining the GMWM Estimator
#' @description This function uses the Generalized Method of Wavelet Moments (GMWM) to estimate the parameters of a time series model.
#' @param theta A \code{vec} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} containing a list of parameters (e.g. AR(1) = c(1,1), ARMA(p,q) = c(p,q,1))
#' @param model_type A \code{string} that represents the model transformation
#' @param wv_empir A \code{vec} that contains the empirical wavelet variance
#' @param omega A \code{mat} that represents the covariance matrix.
#' @param scales A \code{vec} that contains the scales or taus (2^(1:J))
#' @param starting A \code{bool} that indicates whether we guessed starting (T) or the user supplied estimates (F).
#' @return A \code{vec} that contains the parameter estimates from GMWM estimator.
#' @details
#' If type = "imu" or "ssm", then parameter vector should indicate the characters of the models that compose the latent or state-space model.
#' The model options are:
#' \itemize{
#'   \item{"AR1"}{a first order autoregressive process with parameters \eqn{(\phi,\sigma^2)}{phi, sigma^2}}
#'   \item{"ARMA"}{an autoregressive moving average process with parameters \eqn{(\phi _p, \theta _q, \sigma^2)}{phi[p], theta[q], sigma^2}}
#'   \item{"DR"}{a drift with parameter \eqn{\omega}{omega}}
#'   \item{"QN"}{a quantization noise process with parameter \eqn{Q}}
#'   \item{"RW"}{a random walk process with parameter \eqn{\sigma^2}{sigma^2}}
#'   \item{"WN"}{a white noise process with parameter \eqn{\sigma^2}{sigma^2}}
#' }
#' If model_type = "imu" or type = "ssm" then
#' starting values pass through an initial bootstrap and pseudo-optimization before being passed to the GMWM optimization.
#' If robust = TRUE the function takes the robust estimate of the wavelet variance to be used in the GMWM estimation procedure.
#' 
#' @author JJB
#' @references Wavelet variance based estimation for composite stochastic processes, S. Guerrier and Robust Inference for Time Series Models: a Wavelet-Based Framework, S. Guerrier
#' @keywords internal
#' @backref src/gmwm_logic.cpp
#' @backref src/gmwm_logic.h
gmwm_engine <- function(theta, desc, objdesc, model_type, wv_empir, omega, scales, starting) {
    .Call('_simts_gmwm_engine', PACKAGE = 'simts', theta, desc, objdesc, model_type, wv_empir, omega, scales, starting)
}

#' @title Update Wrapper for the GMWM Estimator
#' @description This function uses information obtained previously (e.g. WV covariance matrix) to re-estimate a different model parameterization
#' @param theta A \code{vec} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} containing a list of parameters (e.g. AR(1) = c(1,1), ARMA(p,q) = c(p,q,1))
#' @param model_type A \code{string} that represents the model transformation
#' @param scales A \code{vec} that contains the scales or taus (2^(1:J))
#' @param starting A \code{bool} that indicates whether we guessed starting (T) or the user supplied estimates (F).
#' @return A \code{field<mat>} that contains the parameter estimates from GMWM estimator.
#' @author JJB
#' @references Wavelet variance based estimation for composite stochastic processes, S. Guerrier and Robust Inference for Time Series Models: a Wavelet-Based Framework, S. Guerrier
#' @keywords internal
#' @backref src/gmwm_logic.cpp
#' @backref src/gmwm_logic.h
gmwm_update_cpp <- function(theta, desc, objdesc, model_type, N, expect_diff, ranged, orgV, scales, wv, starting, compute_v, K, H, G, robust, eff) {
    .Call('_simts_gmwm_update_cpp', PACKAGE = 'simts', theta, desc, objdesc, model_type, N, expect_diff, ranged, orgV, scales, wv, starting, compute_v, K, H, G, robust, eff)
}

#' @title Master Wrapper for the GMWM Estimator
#' @description This function generates WV, GMWM Estimator, and an initial test estimate.
#' @param data A \code{vec} containing the data.
#' @param theta A \code{vec} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} containing a list of parameters (e.g. AR(1) = c(1,1), ARMA(p,q) = c(p,q,1))
#' @param model_type A \code{string} that represents the model transformation
#' @param starting A \code{bool} that indicates whether the supplied values are guessed (T) or are user-based (F).
#' @param alpha A \code{double} that handles the alpha level of the confidence interval (1-alpha)*100
#' @param compute_v A \code{string} that describes what kind of covariance matrix should be computed.
#' @param K An \code{int} that controls how many times theta is updated.
#' @param H An \code{int} that controls how many bootstrap replications are done.
#' @param G An \code{int} that controls how many guesses at different parameters are made.
#' @param robust A \code{bool} that indicates whether the estimation should be robust or not.
#' @param eff A \code{double} that specifies the amount of efficiency required by the robust estimator.
#' @return A \code{field<mat>} that contains a list of ever-changing estimates...
#' @author JJB
#' @references Wavelet variance based estimation for composite stochastic processes, S. Guerrier and Robust Inference for Time Series Models: a Wavelet-Based Framework, S. Guerrier
#' @keywords internal
#' @export
#' @backref src/gmwm_logic.cpp
#' @backref src/gmwm_logic.h
gmwm_master_cpp <- function(data, theta, desc, objdesc, model_type, starting, alpha, compute_v, K, H, G, robust, eff) {
    .Call('_simts_gmwm_master_cpp', PACKAGE = 'simts', data, theta, desc, objdesc, model_type, starting, alpha, compute_v, K, H, G, robust, eff)
}

#' @title Randomly guess a starting parameter
#' @description Sets starting parameters for each of the given parameters. 
#' @param desc A \code{vector<string>} that contains the model's components.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @param model_type A \code{string} that indicates whether it is an SSM or sensor.
#' @param num_param An \code{unsigned int} number of parameters in the model (e.g. # of thetas).
#' @param expect_diff A \code{double} that contains the mean of the first difference of the data
#' @param N A \code{integer} that contains the number of observations in the data.
#' @param tau A \code{vec} that contains the scales. (e.g. 2^(1:J))
#' @param G A \code{integer} that indicates how many random draws that should be performed.
#' @return A \code{vec} containing smart parameter starting guesses to be iterated over.
#' @keywords internal
guess_initial <- function(desc, objdesc, model_type, num_param, expect_diff, N, wv, tau, ranged, G) {
    .Call('_simts_guess_initial', PACKAGE = 'simts', desc, objdesc, model_type, num_param, expect_diff, N, wv, tau, ranged, G)
}

#' @title Randomly guess starting parameters for AR1
#' @description Sets starting parameters for each of the given parameters. 
#' @param draw_id An \code{unsigned int} that contains the draw principles.
#' @param last_phi A \code{double} containing the last guessed phi value.
#' @param sigma2_total A \code{double} that contains the sum of all WVs. 
#' @param model_type A \code{string} that describes the model transformation.
#' @return A \code{vec} containing smart parameter starting guesses to be iterated over.
#' @keywords internal
ar1_draw <- function(draw_id, last_phi, sigma2_total, model_type) {
    .Call('_simts_ar1_draw', PACKAGE = 'simts', draw_id, last_phi, sigma2_total, model_type)
}

#' @title Randomly guess starting parameters for ARMA
#' @description Sets starting parameters for each of the given parameters. 
#' @param p An \code{unsigned int} that contains the amount of AR parameters to generate.
#' @param q An \code{unsigned int} that contains the amount of MA parameters to generate.
#' @param sigma2_total A \code{double} that contains the sum of all WVs. 
#' @return A \code{vec} containing smart parameter starting guesses to be iterated over.
#' @keywords internal
arma_draws <- function(p, q, sigma2_total) {
    .Call('_simts_arma_draws', PACKAGE = 'simts', p, q, sigma2_total)
}

#' @title Randomly guess a starting parameter
#' @description Sets starting parameters for each of the given parameters. 
#' @param desc A \code{vector<string>} that contains the model's components.
#' @param objdesc A \code{field<vec>} that contains an object description (e.g. values) of the model.
#' @param model_type A \code{string} that indicates whether it is an SSM or sensor.
#' @param num_param An \code{unsigned int} number of parameters in the model (e.g. # of thetas).
#' @param expect_diff A \code{double} that contains the mean of the first difference of the data
#' @param N A \code{integer} that contains the number of observations in the data.
#' @param wv_empir A \code{vec} that contains the empirical wavelet variance.
#' @param tau A \code{vec} that contains the scales. (e.g. 2^(1:J))
#' @param B A \code{integer} that indicates how many random draws that should be performed.
#' @return A \code{vec} containing smart parameter starting guesses to be iterated over.
#' @keywords internal
guess_initial_old <- function(desc, objdesc, model_type, num_param, expect_diff, N, wv_empir, tau, B) {
    .Call('_simts_guess_initial_old', PACKAGE = 'simts', desc, objdesc, model_type, num_param, expect_diff, N, wv_empir, tau, B)
}

#' @title Indirect Inference for ARMA
#' @description Option for indirect inference
#' @param ar A \code{vec} that contains the coefficients of the AR process.
#' @param ma A \code{vec} that contains the coefficients of the MA process.
#' @param sigma2 A \code{double} that indicates the sigma2 parameter of the ARMA process.
#' @param N A \code{int} that indicates how long the time series is.
#' @param robust A \code{bool} that indicates whether the estimation should be robust or not.
#' @param eff A \code{double} that specifies the amount of efficiency required by the robust estimator.
#' @param H A \code{int} that indicates how many iterations should take place.
#' @return A \code{vec} with the indirect inference results.
#' @keywords internal
idf_arma <- function(ar, ma, sigma2, N, robust, eff, H) {
    .Call('_simts_idf_arma', PACKAGE = 'simts', ar, ma, sigma2, N, robust, eff, H)
}

#' @title Indirect Inference for ARMA
#' @description Option for indirect inference
#' @param ar A \code{vec} that contains the coefficients of the AR process.
#' @param ma A \code{vec} that contains the coefficients of the MA process.
#' @param sigma2 A \code{double} that indicates the sigma2 parameter of the ARMA process.
#' @param N A \code{int} that indicates how long the time series is.
#' @param robust A \code{bool} that indicates whether the estimation should be robust or not.
#' @param eff A \code{double} that specifies the amount of efficiency required by the robust estimator.
#' @param H A \code{int} that indicates how many iterations should take place.
#' @return A \code{vec} with the indirect inference results.
#' @keywords internal
idf_arma_total <- function(ar, ma, sigma2, N, robust, eff, H) {
    .Call('_simts_idf_arma_total', PACKAGE = 'simts', ar, ma, sigma2, N, robust, eff, H)
}

#' @title Calculate the Psi matrix
#' @description Computes the Psi matrix using supplied parameters
#' @param A first derivative matrix
#' @param v_hat bootstrapped V
#' @param omega original omega matrix
#' @backref src/inference.cpp
#' @backref src/inference.h
#' @return A \code{mat} that has the first column 
#' @keywords internal
calculate_psi_matrix <- function(A, v_hat, omega) {
    .Call('_simts_calculate_psi_matrix', PACKAGE = 'simts', A, v_hat, omega)
}

#' @title Format the Confidence Interval for Estimates
#' @description Creates hi and lo confidence based on SE and alpha.
#' @param theta A \code{vec} containing the estimates
#' @param se A \code{vec} containing the standard error
#' @param alpha A \code{double} that contains the confidence level.
#' @return A \code{mat} that has:
#' \itemize{
#' \item Column 1: Lo CI
#' \item Column 2: Hi CI
#' \item Column 3: SE
#' }
#' @backref src/inference.cpp
#' @backref src/inference.h
#' @keywords internal
format_ci <- function(theta, se, alpha) {
    .Call('_simts_format_ci', PACKAGE = 'simts', theta, se, alpha)
}

#' @title Generate the Confidence Interval for Theta Estimates
#' @description Create an Asymptotic CI for the Theta Estimates.
#' @param theta A \code{vec} containing the estimates
#' @param A A \code{mat} that is the first derivative matrix.
#' @param v_hat A \code{mat} that is the bootstrapped V matrix
#' @param omega A \code{mat} that is the inverse of the diagonal V matrix.
#' @param alpha A \code{double} that contains the confidence level.
#' @return A \code{mat} that has the first column 
#' @backref src/inference.cpp
#' @backref src/inference.h
#' @keywords internal
theta_ci <- function(theta, A, v_hat, omega, alpha) {
    .Call('_simts_theta_ci', PACKAGE = 'simts', theta, A, v_hat, omega, alpha)
}

#' @title Compute the GOF Test
#' @description yaya
#' @template tsobj_cpp
#' @param model_type A \code{string} that contains the model type: \code{"imu"} or \code{"ssm"}
#' @param tau A \code{vec} containing the scales of a proccess.
#' @param v_hat A \code{mat} that contains the bootstrapped matrix.
#' @param wv_empir A \code{vec} that contains the empirical wavelet variance.
#' @return A \code{vec} that has
#' \itemize{
#' \item Test Statistic
#' \item P-Value
#' \item DF
#' } 
#' @backref src/inference.cpp
#' @backref src/inference.h
#' @keywords internal
gof_test <- function(theta, desc, objdesc, model_type, tau, v_hat, wv_empir) {
    .Call('_simts_gof_test', PACKAGE = 'simts', theta, desc, objdesc, model_type, tau, v_hat, wv_empir)
}

#' @title Compute the Bootstrapped GoF Test
#' @description Handles the bootstrap computation and the bootstrapped p-value.
#' @param obj_value A \code{double} that contains the optimized objective function value.
#' @param bs_obj_values A \code{vec} that contains the objective function values under bootstrap.
#' @param alpha A \code{double} that indicates the confidence.
#' @param bs_gof_p_ci A \code{bool} that indicates whether CIs should be included or not.
#' @return A \code{vec} that has
#' \itemize{
#' \item Test Statistic
#' \item Low CI
#' \item Upper CI - BS
#' } 
#' @backref src/inference.cpp
#' @backref src/inference.h
#' @keywords internal
bootstrap_gof_test <- function(obj_value, bs_obj_values, alpha, bs_gof_p_ci) {
    .Call('_simts_bootstrap_gof_test', PACKAGE = 'simts', obj_value, bs_obj_values, alpha, bs_gof_p_ci)
}

#' MLR in Armadillo
#' 
#' Perform Multiple Linear Regression using armadillo in C++
#' 
#' @param y A \code{vec} of length \eqn{N\times 1}{N x 1} containing the responses.
#' @param X A \code{mat} with dimensions \eqn{N \times p}{N x p}, which is the design matrix.
#' @return A \code{field<vec>} with:
#' \describe{
#'   \item{coef}{Coefficients}
#'   \item{resid}{Residuals}
#'   \item{sigma2}{Sigma^2}
#' }
#' @keywords internal
lm_arma <- function(y, X) {
    .Call('_simts_lm_arma', PACKAGE = 'simts', y, X)
}

#' Linear Regression with Drift
#' 
#' Perform a linear regression with drift.
#' 
#' @param x A \code{vec} of length \eqn{N\times 1}{N x 1} containing the responses.
#' @return A \code{field<vec>} with:
#' \describe{
#'   \item{coef}{Coefficients}
#'   \item{resid}{Residuals}
#'   \item{sigma2}{Sigma^2}
#' }
#' @keywords internal
lm_dr <- function(x) {
    .Call('_simts_lm_dr', PACKAGE = 'simts', x)
}

#' @title B Matrix
#' @description B Matrix
#' @param A A \code{mat} containing the first derivatives of the process.
#' @param at_omega A \code{mat} containing A^T * Omega
#' @return A \code{mat}
#' @backref src/model_selection.cpp
#' @backref src/model_selection.h
#' @keywords internal
B_matrix <- function(A, at_omega) {
    .Call('_simts_B_matrix', PACKAGE = 'simts', A, at_omega)
}

#' @title Model Score
#' @description Calculates the modeling score of a GMWM
#' @param A A \code{mat} that contains the first derivatives of the processes
#' @param omega A \code{mat} that contains the omega used when calculating the GMWM
#' @param v_hat A \code{mat} that contains the covariance matrix
#' @return A \code{vec}
#' @keywords internal
#' @backref src/model_selection.cpp
#' @backref src/model_selection.h
#' @details
#' The equation is slightly different than that stated in the paper due to the bootstrap already incorporating in 
#' N.
model_score <- function(A, D, omega, v_hat, obj_value) {
    .Call('_simts_model_score', PACKAGE = 'simts', A, D, omega, v_hat, obj_value)
}

#' @title Extract Object
#' @description Extracts the object information and returns it.
#' @param theta A \code{vec} containing the theta values.
#' @param objdesc A \code{vec} at the desc point.
#' @param cur_position An \code{integer} at the current position.
#' @return A \code{field<vec>} containing the breakdown of the object.
#' @keywords internal
obj_extract <- function(theta, objdesc, cur_position) {
    .Call('_simts_obj_extract', PACKAGE = 'simts', theta, objdesc, cur_position)
}

#' @title Retrieve GMWM starting value from Yannick's objective function
#' @description Obtains the GMWM starting value given by Yannick's objective function optimization
#' @template tsobj_cpp
#' @param model_type A \code{string} containing the model type. Either 'imu' or 'ssm'
#' @param wv_empir A \code{vec} containing the empirical wavelet variance.
#' @param tau A \code{vec} that contains the scales of 2^(1:J), where J is the number of scales created by the decomposition.
#' @return A \code{double} that is the value of the Objective function under Yannick's starting algorithm
#' @keywords internal
getObjFunStarting <- function(theta, desc, objdesc, model_type, wv_empir, tau) {
    .Call('_simts_getObjFunStarting', PACKAGE = 'simts', theta, desc, objdesc, model_type, wv_empir, tau)
}

#' @title Retrieve GMWM starting value from Yannick's objective function
#' @description Obtains the GMWM starting value given by Yannick's objective function optimization
#' @template tsobj_cpp
#' @param model_type A \code{string} containing the model type. Either 'imu' or 'ssm'
#' @param omega A \code{mat} that is the inverse of the diagonal of the V matrix.
#' @param wv_empir A \code{vec} containing the empirical wavelet variance.
#' @param tau A \code{vec} that contains the scales of 2^(1:J), where J is the number of scales created by the decomposition.
#' @return A \code{double} that is the value of the Objective function under Yannick's starting algorithm
#' @keywords internal
getObjFun <- function(theta, desc, objdesc, model_type, omega, wv_empir, tau) {
    .Call('_simts_getObjFun', PACKAGE = 'simts', theta, desc, objdesc, model_type, omega, wv_empir, tau)
}

#' @title Root Finding C++
#' @description Used to interface with Armadillo
#' @param z A \code{cx_vec} (complex vector) that has 1 in the beginning (e.g. c(1,3i,-3i))
#' @keywords internal
do_polyroot_arma <- function(z) {
    .Call('_simts_do_polyroot_arma', PACKAGE = 'simts', z)
}

#' @title Root Finding C++
#' @description Vroom Vroom
#' @param z A \code{vec<complex<double>} (complex vector) that has 1 in the beginning (e.g. c(1,3i,-3i))
#' @keywords internal
do_polyroot_cpp <- function(z) {
    .Call('_simts_do_polyroot_cpp', PACKAGE = 'simts', z)
}

#' ARMA process to WV
#' 
#' This function computes the Haar Wavelet Variance of an ARMA process
#' @param ar     A \code{vec} containing the coefficients of the AR process
#' @param ma     A \code{vec} containing the coefficients of the MA process
#' @param sigma2 A \code{double} containing the residual variance
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the ARMA process.
#' @details
#' The function is a generic implementation that requires a stationary theoretical autocorrelation function (ACF)
#' and the ability to transform an ARMA(\eqn{p},\eqn{q}) process into an MA(\eqn{\infty}{infinity}) (e.g. infinite MA process).
#' @template to_wv/haar_arma
#' @backref src/process_to_wv.cpp
#' @backref src/process_to_wv.h
arma_to_wv <- function(ar, ma, sigma2, tau) {
    .Call('_simts_arma_to_wv', PACKAGE = 'simts', ar, ma, sigma2, tau)
}

#' @title Helper Function for ARMA to WV Approximation
#' @description Indicates where the minimum ARMAacf value is and returns that as an index.
#' @param ar A \code{vec} containing the coefficients of the AR process
#' @param ma A \code{vec} containing the coefficients of the MA process
#' @param last_tau An \code{int} the Jth scale of 2^(1:J)
#' @param alpha A \code{double} indicating the cutoff.
#' @return A \code{vec} containing the wavelet variance of the ARMA process.
#' @keywords internal
acf_sum <- function(ar, ma, last_tau, alpha = 0.99) {
    .Call('_simts_acf_sum', PACKAGE = 'simts', ar, ma, last_tau, alpha)
}

#' ARMA process to WV Approximation
#' 
#' This function computes the (haar) WV of an ARMA process
#' @param ar A \code{vec} containing the coefficients of the AR process
#' @param ma A \code{vec} containing the coefficients of the MA process
#' @param sigma2 A \code{double} containing the residual variance
#' @template misc/tau
#' @param alpha A \code{double} indicating the cutoff.
#' @return A \code{vec} containing the wavelet variance of the ARMA process.
#' @keywords internal
#' @details
#' This function provides an approximation to the \code{\link{arma_to_wv}} as computation times
#' were previously a concern. However, this is no longer the case and, thus, this has been left
#' in for the curious soul to discover... 
#' @template to_wv/haar_arma
#' @backref src/process_to_wv.cpp
#' @backref src/process_to_wv.h
arma_to_wv_app <- function(ar, ma, sigma2, tau, alpha = 0.9999) {
    .Call('_simts_arma_to_wv_app', PACKAGE = 'simts', ar, ma, sigma2, tau, alpha)
}

#' ARMA(1,1) to WV
#' 
#' This function computes the WV (haar) of an Autoregressive Order 1 - Moving Average Order 1 (ARMA(1,1)) process.
#' @param phi    A \code{double} corresponding to the autoregressive term.
#' @param theta  A \code{double} corresponding to the moving average term. 
#' @param sigma2 A \code{double} the variance of the process. 
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the ARMA(1,1) process.
#' @details 
#' This function is significantly faster than its generalized counter part
#' \code{\link{arma_to_wv}}
#' 
#' @template to_wv/haar_arma11
#' @backref src/process_to_wv.cpp
#' @backref src/process_to_wv.h
arma11_to_wv <- function(phi, theta, sigma2, tau) {
    .Call('_simts_arma11_to_wv', PACKAGE = 'simts', phi, theta, sigma2, tau)
}

#' AR(1) process to WV
#' 
#' This function computes the Haar WV of an AR(1) process
#' @param phi    A \code{double} that is the phi term of the AR(1) process
#' @param sigma2 A \code{double} corresponding to variance of AR(1) process
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the AR(1) process.
#' @details 
#' This function is significantly faster than its generalized counter part
#' \code{\link{arma_to_wv}}.
#' 
#' @template to_wv/haar_ar1
#' @backref src/process_to_wv.cpp
#' @backref src/process_to_wv.h
ar1_to_wv <- function(phi, sigma2, tau) {
    .Call('_simts_ar1_to_wv', PACKAGE = 'simts', phi, sigma2, tau)
}

#' Moving Average Order 1 (MA(1)) to WV
#' 
#' This function computes the WV (haar) of a Moving Average order 1 (MA1) process.
#' @param theta A \code{double} corresponding to the moving average term. 
#' @param sigma2  A \code{double} the variance of the process. 
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the MA(1) process.
#' @details 
#' This function is significantly faster than its generalized counter part
#' \code{\link{arma_to_wv}}.
#' 
#' @template to_wv/haar_ma1
#' @backref src/process_to_wv.cpp
#' @backref src/process_to_wv.h
ma1_to_wv <- function(theta, sigma2, tau) {
    .Call('_simts_ma1_to_wv', PACKAGE = 'simts', theta, sigma2, tau)
}

#' Quantisation Noise (QN) to WV
#' 
#' This function compute the Haar WV of a Quantisation Noise (QN) process
#' @param q2  A \code{double} corresponding to variance of drift
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the QN.
#' @template to_wv/haar_qn
#' @backref src/process_to_wv.cpp
#' @backref src/process_to_wv.h
qn_to_wv <- function(q2, tau) {
    .Call('_simts_qn_to_wv', PACKAGE = 'simts', q2, tau)
}

#' @title Gaussian White Noise to WV
#' @description This function compute the Haar WV of a Gaussian White Noise process
#' @param sigma2 A \code{double} corresponding to variance of WN
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the white noise.
#' @template to_wv/haar_wn
wn_to_wv <- function(sigma2, tau) {
    .Call('_simts_wn_to_wv', PACKAGE = 'simts', sigma2, tau)
}

#' @title Random Walk to WV
#' @description This function compute the WV (haar) of a Random Walk process
#' @param gamma2 A \code{double} corresponding to variance of RW
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the random walk.
#' @template to_wv/haar_rw
rw_to_wv <- function(gamma2, tau) {
    .Call('_simts_rw_to_wv', PACKAGE = 'simts', gamma2, tau)
}

#' @title Drift to WV
#' @description This function compute the WV (haar) of a Drift process
#' @param omega A \code{double} corresponding to the slope of the drift
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the drift.
#' @template to_wv/haar_dr
dr_to_wv <- function(omega, tau) {
    .Call('_simts_dr_to_wv', PACKAGE = 'simts', omega, tau)
}

#' Model Process to WV
#' 
#' This function computes the summation of all Processes to WV (haar) in a given model
#' @param theta   A \code{vec} containing the list of estimated parameters.
#' @param desc    A \code{vector<string>} containing a list of descriptors.
#' @param objdesc A \code{field<vec>} containing a list of object descriptors.
#' @template misc/tau
#' @return A \code{vec} containing the wavelet variance of the model.
#' @keywords internal
theoretical_wv <- function(theta, desc, objdesc, tau) {
    .Call('_simts_theoretical_wv', PACKAGE = 'simts', theta, desc, objdesc, tau)
}

#' Each Models Process Decomposed to WV
#' 
#' This function computes each process to WV (haar) in a given model.
#' @param theta   A \code{vec} containing the list of estimated parameters.
#' @param desc    A \code{vector<string>} containing a list of descriptors.
#' @param objdesc A \code{field<vec>} containing a list of object descriptors.
#' @template misc/tau
#' @return A \code{mat} containing the wavelet variance of each process in the model
#' @keywords internal
decomp_theoretical_wv <- function(theta, desc, objdesc, tau) {
    .Call('_simts_decomp_theoretical_wv', PACKAGE = 'simts', theta, desc, objdesc, tau)
}

#' Decomposed WV to Single WV
#' 
#' This function computes the combined processes to WV (haar) in a given model.
#' @param decomp A \code{mat} with scales as rows and processes as columns
#' @return A \code{vec} containing the wavelet variance of the process for the overall model
#' @keywords internal
decomp_to_theo_wv <- function(decomp) {
    .Call('_simts_decomp_to_theo_wv', PACKAGE = 'simts', decomp)
}

#' @title Read an IMU Binary File into R
#' 
#' @description
#' The function will take a file location in addition to the type of sensor it
#' came from and read the data into R.
#' 
#' @param file_path A \code{string} that contains the full file path.
#' @param imu_type A \code{string} that contains a supported IMU type given below.
#' @details
#' Currently supports the following IMUs:
#' \itemize{
#' \item IMAR
#' \item LN200
#' \item LN200IG
#' \item IXSEA
#' \item NAVCHIP_INT
#' \item NAVCHIP_FLT
#' }
#' 
#' We hope to soon be able to support delimited files.
#' @return A matrix with dimensions N x 7, where the columns represent:
#' \describe{
#' \item{Col 0}{Time}
#' \item{Col 1}{Gyro 1}
#' \item{Col 2}{Gyro 2}
#' \item{Col 3}{Gyro 3}
#' \item{Col 4}{Accel 1}
#' \item{Col 5}{Accel 2}
#' \item{Col 6}{Accel 3}
#' }
#' @references
#' Thanks goes to Philipp Clausen of Labo TOPO, EPFL, Switzerland, topo.epfl.ch, Tel:+41(0)21 693 27 55
#' for providing a matlab function that reads in IMUs.
#' The function below is a heavily modified port of MATLAB code into Armadillo/C++. 
#' 
#' @keywords internal
read_imu <- function(file_path, imu_type) {
    .Call('_simts_read_imu', PACKAGE = 'simts', file_path, imu_type)
}

#' @title Generate a sequence of values
#' @description Creates a vector containing a sequence of values starting at the initial point and going to the terminal point.
#' @param a An \code{int}, that denotes the starting point.
#' @param b An \code{int}, that denotes the ending point.
#' @return A \code{vector} containing values moving from a to b. There are no restrictions on A's range.
#' @author James J Balamuta
#' @keywords internal
seq_cpp <- function(a, b) {
    .Call('_simts_seq_cpp', PACKAGE = 'simts', a, b)
}

#' @title Generate a sequence of values based on supplied number
#' @description Creates a vector containing a sequence of values starting at 1 and going to the terminal point.
#' @param n An \code{int} that denotes the length of the vector.
#' @return A \code{vector} containing values moving from 1 to n.
#' @author James J Balamuta
#' @keywords internal
seq_len_cpp <- function(n) {
    .Call('_simts_seq_len_cpp', PACKAGE = 'simts', n)
}

#' @title Find Quantiles
#' @description Attempts to find quantiles
#' @param x A \code{vec} of data
#' @param probs A \code{vec} of the quantiles to find.
#' @return A \code{vector} containing the quantiles
#' @author James J Balamuta
#' @keywords internal
quantile_cpp <- function(x, probs) {
    .Call('_simts_quantile_cpp', PACKAGE = 'simts', x, probs)
}

#' @title Lagged Differences in Armadillo
#' @description Returns the ith difference of a time series of rth lag.
#' @param x A \code{vec} that is the time series
#' @param lag A \code{unsigned int} that indicates the lag
#' @param differences A \code{dif} that indicates how many differences should be taken
#' @return A \code{vector} containing the differenced time series.
#' @author JJB
#' @keywords internal
diff_cpp <- function(x, lag, differences) {
    .Call('_simts_diff_cpp', PACKAGE = 'simts', x, lag, differences)
}

#' @title Converting an ARMA Process to an Infinite MA Process
#' @description Takes an ARMA function and converts it to an infinite MA process.
#' @param ar A \code{column vector} of length p
#' @param ma A \code{column vector} of length q
#' @param lag_max A \code{int} of the largest MA(Inf) coefficient required.
#' @return A \code{column vector} containing coefficients
#' @details This function is a port of the base stats package's ARMAtoMA. There is no significant speed difference between the two.
#' @author R Core Team and JJB
#' @keywords internal
ARMAtoMA_cpp <- function(ar, ma, lag_max) {
    .Call('_simts_ARMAtoMA_cpp', PACKAGE = 'simts', ar, ma, lag_max)
}

#' @title Time Series Convolution Filters
#' @description Applies a convolution filter to a univariate time series.
#' @param x A \code{column vector} of length T
#' @param filter A \code{column vector} of length f
#' @param sides An \code{int} that takes either 1:for using past values only or 2: filter coefficients are centered around lag 0.
#' @param circular A \code{bool} that indicates if the filter should be wrapped around the ends of the time series.
#' @return A \code{column vec} that contains the results of the filtering process.
#' @details This is a port of the cfilter function harnessed by the filter function in stats. 
#' It is about 5-7 times faster than R's base function. The benchmark was done on iMac Late 2013 using vecLib as the BLAS.
#' @author R Core Team and JJB
#' @keywords internal
cfilter <- function(x, filter, sides, circular) {
    .Call('_simts_cfilter', PACKAGE = 'simts', x, filter, sides, circular)
}

#' @title Time Series Recursive Filters
#' @description Applies a recursive filter to a univariate time series.
#' @usage rfilter(x, filter, init)
#' @param x A \code{column vector} of length T
#' @param filter A \code{column vector} of length f
#' @param init A \code{column vector} of length f that contains the initial values of the time series in reverse.
#' @return x A \code{column vector} with its contents reversed.
#' @details Note: The length of 'init' must be equal to the length of 'filter'.
#' This is a port of the rfilter function harnessed by the filter function in stats. 
#' It is about 6-7 times faster than R's base function. The benchmark was done on iMac Late 2013 using vecLib as the BLAS.
#' @author JJB
#' @keywords internal
rfilter <- function(x, filter, init) {
    .Call('_simts_rfilter', PACKAGE = 'simts', x, filter, init)
}

#' @title Compute Theoretical ACF for an ARMA Process
#' @description Compute the theoretical autocorrelation function for an ARMA process.
#' @usage ARMAacf_cpp(ar,ma,lag_max)
#' @param ar A \code{vector} of length p containing AR coefficients
#' @param ma A \code{vector} of length q containing MA coefficients
#' @param lag_max A \code{unsigned integer} indicating the maximum lag necessary
#' @return x A \code{matrix} listing values from 1...nx in one column and 1...1, 2...2,....,n...n, in the other
#' @details This is an implementaiton of the ARMAacf function in R. It is approximately 40x times faster. The benchmark was done on iMac Late 2013 using vecLib as the BLAS.
#' @author JJB
#' @keywords internal
ARMAacf_cpp <- function(ar, ma, lag_max) {
    .Call('_simts_ARMAacf_cpp', PACKAGE = 'simts', ar, ma, lag_max)
}

#' @title Discrete Fourier Transformation for Autocovariance Function
#' @description Calculates the autovariance function (ACF) using Discrete Fourier Transformation.
#' @param x A \code{cx_vec}. 
#' @return A \code{vec} containing the ACF.
#' @details 
#' This implementation is 2x as slow as Rs. 
#' Two issues: 1. memory resize and 2. unoptimized fft algorithm in arma.
#' Consider piping back into R and rewrapping the object. (Decrease of about 10 microseconds.)
#' @keywords internal
dft_acf <- function(x) {
    .Call('_simts_dft_acf', PACKAGE = 'simts', x)
}

#' @title Mean of the First Difference of the Data
#' @description The mean of the first difference of the data
#' @param x A \code{vec} containing the data 
#' @return A \code{double} that contains the mean of the first difference of the data.
#' @keywords internal
mean_diff <- function(x) {
    .Call('_simts_mean_diff', PACKAGE = 'simts', x)
}

#' Replicate a Vector of Elements \eqn{n} times
#' 
#' This function takes a vector and replicates all of the data \eqn{n} times
#' @param x A \code{vec} containing the data
#' @param n An \code{unsigned int} indicating the number of times the vector should be repeated.
#' @return A \code{vec} with repeated elements of the initial supplied vector.
#' @keywords internal
num_rep <- function(x, n) {
    .Call('_simts_num_rep', PACKAGE = 'simts', x, n)
}

#' @rdname diff_inv
intgr_vec <- function(x, xi, lag) {
    .Call('_simts_intgr_vec', PACKAGE = 'simts', x, xi, lag)
}

#' @param xi A \code{vec} with length \eqn{lag*d} that provides initial values for the integration.
#' @rdname diff_inv
diff_inv_values <- function(x, lag, d, xi) {
    .Call('_simts_diff_inv_values', PACKAGE = 'simts', x, lag, d, xi)
}

#' Discrete Intergral: Inverse Difference
#' 
#' Takes the inverse difference (e.g. goes from diff() result back to previous vector)
#' @param x   A \code{vec} containing the data
#' @param lag An \code{unsigned int} indicating the lag between observations. 
#' @param d   An \code{unsigned int} which gives the number of "differences" to invert.
#' @keywords internal
diff_inv <- function(x, lag, d) {
    .Call('_simts_diff_inv', PACKAGE = 'simts', x, lag, d)
}

#' @title Auto-Covariance and Correlation Functions
#' @description The acf function computes the estimated
#' autocovariance or autocorrelation for both univariate and multivariate cases.
#' @param x      A \code{matrix} with dimensions \eqn{N \times S}{N x S} or N observations and S processes
#' @param lagmax A \code{integer}
#' @param cor    A \code{bool} indicating whether the correlation 
#' (\code{TRUE}) or covariance (\code{FALSE}) should be computed.
#' @param demean A \code{bool} indicating whether the data should be detrended
#'  (\code{TRUE}) or not (\code{FALSE})
#' @keywords internal
.acf <- function(x, lagmax = 0L, cor = TRUE, demean = TRUE) {
    .Call('_simts_acf', PACKAGE = 'simts', x, lagmax, cor, demean)
}

#' Truncated Normal Distribution Sampling Algorithm
#' 
#' Enables sampling from a truncated normal
#' @param n      An \code{unsigned int} indicating the number of observations to generate.
#' @param mu     A \code{double} indicating the mean of the normal.
#' @param sigma  A \code{double} indicating the standard deviation of the normal.
#' @param a      A \code{double} that is the lower bound of the truncated normal.
#' @param b      A \code{double} that is the upper bound of the truncated normal.
rtruncated_normal <- function(n, mu, sigma, a, b) {
    .Call('_simts_rtruncated_normal', PACKAGE = 'simts', n, mu, sigma, a, b)
}

#' Calculates Length of Seasonal Padding
#' 
#' Computes the total phi and total theta vector length.
#' @param np  An \code{unsigned int} containing the number of non-seasonal phi parameters.
#' @param nq  An \code{unsigned int} containing the number of non-seasonal theta parameters.
#' @param nsp An \code{unsigned int} containing the number of seasonal phi parameters.
#' @param nsq An \code{unsigned int} containing the number of seasonal theta parameters.
#' @return A \code{vec} with rows:
#' \describe{
#'  \item{p}{Number of phi parameters}
#'  \item{q}{Number of theta parameters}
#' }
#' @keywords internal
#' 
#' 
sarma_calculate_spadding <- function(np, nq, nsp, nsq, ns) {
    .Call('_simts_sarma_calculate_spadding', PACKAGE = 'simts', np, nq, nsp, nsq, ns)
}

#' Efficient way to merge items together
#' @keywords internal
sarma_params_construct <- function(ar, ma, sar, sma) {
    .Call('_simts_sarma_params_construct', PACKAGE = 'simts', ar, ma, sar, sma)
}

#' Determine parameter expansion based upon objdesc
#' 
#' Calculates the necessary vec space needed to pad the vectors
#' for seasonal terms. 
#' @param objdesc A \code{vec} with the appropriate sarima object description
#' @return A \code{vec} with the structure:
#' \describe{
#' \item{np}{Number of Non-Seasonal AR Terms}
#' \item{nq}{Number of Non-Seasonal MA Terms}
#' \item{nsp}{Number of Seasonal AR Terms}
#' \item{nsq}{Number of Seasonal MA Terms}
#' \item{ns}{Number of Seasons (e.g. 12 is year)}
#' \item{p}{Total number of phi terms}
#' \item{q}{Total number of theta terms}
#' }
#' @keywords internal
sarma_components <- function(objdesc) {
    .Call('_simts_sarma_components', PACKAGE = 'simts', objdesc)
}

#' (Internal) Expand the SARMA Parameters
#' @param params  A \code{vec} containing the theta values of the parameters.
#' @inheritParams sarma_calculate_spadding
#' @param p An \code{unsigned int} that is the total size of the phi vector. 
#' @param q An \code{unsigned int} that is the total size of the theta vector. 
#' @return A \code{field<vec>} that contains the expansion. 
#' @keywords internal
sarma_expand_unguided <- function(params, np, nq, nsp, nsq, ns, p, q) {
    .Call('_simts_sarma_expand_unguided', PACKAGE = 'simts', params, np, nq, nsp, nsq, ns, p, q)
}

#' Expand Parameters for an SARMA object
#' 
#' Creates an expanded PHI and THETA vector for use in other objects. 
#' @param params  A \code{vec} containing the theta values of the parameters.
#' @param objdesc A \code{vec} containing the model term information.
#' @return A \code{field<vec>} of size two as follows:
#' \itemize{
#'   \item AR    values
#'   \item THETA values
#' }
#' @details 
#' The \code{objdesc} is assumed to have the structure of:
#' \itemize{
#' \item AR(p)
#' \item MA(q)
#' \item SAR(P)
#' \item SMA(Q)
#' \item Seasons
#' }
#' @keywords internal
sarma_expand <- function(params, objdesc) {
    .Call('_simts_sarma_expand', PACKAGE = 'simts', params, objdesc)
}

#' @title Routing function for summary info
#' @description Gets all the data for the summary.gmwm function.
#' @param theta A \code{vec} with dimensions N x 1 that contains user-supplied initial values for parameters
#' @param desc A \code{vector<string>} indicating the models that should be considered.
#' @param objdesc A \code{field<vec>} containing a list of parameters (e.g. AR(1) = c(1,1), ARMA(p,q) = c(p,q,1))
#' @param model_type A \code{string} that represents the model transformation
#' @param wv_empir A \code{vec} that 
#' @param theo A \code{vec} that
#' @param scales A \code{vec} that
#' @param V A \code{mat} that contains the V matrix used to obtain the GMWM.
#' @param omega A \code{mat} that 
#' @param obj_value A \code{double} that contains the objective function value at the optimized solution.
#' @param N A \code{int} that indicates how long the time series is.
#' @param alpha A \code{double} that handles the alpha level of the confidence interval (1-alpha)*100
#' @param robust A \code{bool} that indicates whether the estimation should be robust or not.
#' @param eff A \code{double} that specifies the amount of efficiency required by the robust estimator.
#' @param inference A \code{bool} that indicates whether inference (e.g. GoF) should be run.
#' @param fullV A \code{bool} that indicates whether the matrix has been fully bootstrapped.
#' @param bs_gof A \code{bool} indicating whether the GoF should be bootstrapped or done asymptotically.
#' @param bs_gof_p_ci A \code{bool} indicating whether a bootstrapped p-value should be generated during the bootstrapped GoF
#' @param bs_ci A \code{bool} that indicates whether a bootstrapped CI should be obtained or to use analytical derivatives.
#' @param B A \code{int} that indicates how many iterations should take place.
#' @return A \code{field<mat>} that contains bootstrapped / asymptotic GoF results as well as CIs.
#' @keywords internal
get_summary <- function(theta, desc, objdesc, model_type, wv_empir, theo, scales, V, omega, obj_value, N, alpha, robust, eff, inference, fullV, bs_gof, bs_gof_p_ci, bs_theta_est, bs_ci, B) {
    .Call('_simts_get_summary', PACKAGE = 'simts', theta, desc, objdesc, model_type, wv_empir, theo, scales, V, omega, obj_value, N, alpha, robust, eff, inference, fullV, bs_gof, bs_gof_p_ci, bs_theta_est, bs_ci, B)
}

#' Pseudo Logit Inverse Function
#' 
#' This function computes the pseudo inverse of a logit transformation of the parameters in order to constrain them to a positive domain 
#' @param x A \code{vec} containing real numbers.
#' @return A \code{vec} containing logit probabilities.
#' @keywords internal
#' @template author/jjb
pseudo_logit_inv <- function(x) {
    .Call('_simts_pseudo_logit_inv', PACKAGE = 'simts', x)
}

#' Logit Inverse Function
#' 
#' This function computes the inverse of a logit transformation of the parameters.
#' @param x A \code{vec} containing real numbers.
#' @return A \code{vec} containing logit probabilities.
#' @keywords internal
#' @template author/jjb
logit_inv <- function(x) {
    .Call('_simts_logit_inv', PACKAGE = 'simts', x)
}

#' Pseudo Logit Function
#' 
#' This function compute the link function to constrain parameters to a positive domain.
#' @param x A \code{vec} containing probabilities (e.g. 0 <= x <= 1)
#' @return A \code{vec} containing logit terms.
#' @keywords internal
#' @template author/jjb
pseudo_logit <- function(x) {
    .Call('_simts_pseudo_logit', PACKAGE = 'simts', x)
}

#' Logit Function
#' 
#' This function computes the logit link function.
#' @param x A \code{vec} containing probabilities (e.g. -1 <= x <= 1)
#' @return A \code{vec} containing logit terms.
#' @keywords internal
#' @template author/jjb
logit <- function(x) {
    .Call('_simts_logit', PACKAGE = 'simts', x)
}

#' Logit2 Function
#' 
#' This function computes the logit2 link function.
#' @param x A \code{vec} containing probabilities (e.g. -2 <= x <= 2)
#' @return A \code{vec} containing logit terms.
#' @keywords internal
#' @template author/jjb
logit2 <- function(x) {
    .Call('_simts_logit2', PACKAGE = 'simts', x)
}

#' Logit2 Inverse Function
#' 
#' This function computes the inverse of a logit transformation of the parameters.
#' @param x A \code{vec} containing real numbers.
#' @return A \code{vec} containing logit probabilities.
#' @keywords internal
#' @template author/jjb
logit2_inv <- function(x) {
    .Call('_simts_logit2_inv', PACKAGE = 'simts', x)
}

#' Transform Values for Optimization
#' 
#' Transform parameter guesses prior to estimating with GMWM
#' @template tsobj_cpp
#' @param model_type A \code{string} that contains the model type: \code{"imu"} or \code{"ssm"}
#' @return A \code{vec} containing the transformed guesses.
#' @template author/jjb
#' @keywords internal
transform_values <- function(theta, desc, objdesc, model_type) {
    .Call('_simts_transform_values', PACKAGE = 'simts', theta, desc, objdesc, model_type)
}

#' Revert Transform Values for Display
#' 
#' Undo the previous transform of parameter guesses to obtain the GMWM estimates.
#' @template tsobj_cpp
#' @param model_type A \code{string} that contains the model type: \code{"imu"} or \code{"ssm"}
#' @return A \code{vec} containing the undone transformation of parameters.
#' @template author/jjb
#' @keywords internal
untransform_values <- function(theta, desc, objdesc, model_type) {
    .Call('_simts_untransform_values', PACKAGE = 'simts', theta, desc, objdesc, model_type)
}

#' @title Obtain the smallest polynomial root
#' @description Calculates all the roots of a polynomial and returns the root that is the smallest.
#' @param x A \code{cx_vec} that has a 1 appended before the coefficents. (e.g. c(1, x))
#' @return A \code{double} with the minimum root value.
#' @keywords internal
minroot <- function(x) {
    .Call('_simts_minroot', PACKAGE = 'simts', x)
}

#' @title Check Invertibility Conditions
#' @description Checks the invertiveness of series of coefficients.
#' @param x A \code{cx_vec} that has a 1 appended before the coefficents. (e.g. c(1, x))
#' @return True (if outside unit circle) || False (if inside unit circle)
#' @keywords internal
invert_check <- function(x) {
    .Call('_simts_invert_check', PACKAGE = 'simts', x)
}

#' @title Count Models
#' @description Count the amount of models that exist.
#' @param desc A \code{vector<string>} that contains the model's components.
#' @return A \code{map<string, int>} containing how frequent the model component appears.
#' @keywords internal
count_models <- function(desc) {
    .Call('_simts_count_models', PACKAGE = 'simts', desc)
}

#' @title Order AR1s by size of phi.
#' @description Changes the order of AR1s in a string by size.
#' @template tsobj_cpp
#' @return A \code{vec} that has AR1s shown in descending parameter value.
#' @keywords internal
order_AR1s <- function(theta, desc, objdesc) {
    .Call('_simts_order_AR1s', PACKAGE = 'simts', theta, desc, objdesc)
}

#' @title Transform AR1 to GM
#' @description 
#' Takes AR1 values and transforms them to GM
#' @param theta A \code{vec} that contains AR1 values.
#' @param freq  A \code{double} indicating the frequency of the data.
#' @return A \code{vec} containing GM values.
#' @details
#' The function takes a vector of AR1 values \eqn{\phi}{phi} and \eqn{\sigma ^2}{sigma ^2}
#' and transforms them to GM values \eqn{\beta}{beta} and \eqn{\sigma ^2_{gm}}{sigma ^2[gm]}
#' using the formulas:
#' \eqn{\beta  =  - \frac{{\ln \left( \phi  \right)}}{{\Delta t}}}{beta = -ln(phi)/delta_t}
#' \eqn{\sigma _{gm}^2 = \frac{{{\sigma ^2}}}{{1 - {\phi ^2}}} }{sigma^2[gm] = sigma^2/(1-phi^2)}
#' @keywords internal
#' @author James Balamuta
#' @backref src/ts_model_cpp.cpp
#' @backref src/ts_model_cpp.h
#' @export
ar1_to_gm <- function(theta, freq) {
    .Call('_simts_ar1_to_gm', PACKAGE = 'simts', theta, freq)
}

#' @title Transform GM to AR1
#' @description Takes GM values and transforms them to AR1
#' @param theta A \code{vec} that contains AR1 values.
#' @param freq A \code{double} indicating the frequency of the data.
#' @return A \code{vec} containing GM values.
#' @keywords internal
#' @author James Balamuta
#' The function takes a vector of GM values \eqn{\beta}{beta} and \eqn{\sigma ^2_{gm}}{sigma ^2[gm]}
#' and transforms them to AR1 values \eqn{\phi}{phi} and \eqn{\sigma ^2}{sigma ^2}
#' using the formulas:
#' \eqn{\phi  = \exp \left( { - \beta \Delta t} \right)}{phi = exp(-beta * delta[t])}
#' \eqn{{\sigma ^2} = \sigma _{gm}^2\left( {1 - \exp \left( { - 2\beta \Delta t} \right)} \right)}{sigma^2 = sigma^2[gm]*(1-exp(-2*beta*delta[t]))}
#' @backref src/ts_model_cpp.cpp
#' @backref src/ts_model_cpp.h
#' @export
gm_to_ar1 <- function(theta, freq) {
    .Call('_simts_gm_to_ar1', PACKAGE = 'simts', theta, freq)
}

#' @title Generate the ts model object description
#' @description Creates the ts.model's obj.desc value
#' @param desc A \code{vector<string>} that contains a list of the strings of each process.
#' @return A \code{field<vec>} that contains the object description of each process.
#' @details
#' This function currently does NOT support ARMA(P,Q) models. 
#' That is, there is no support for ARMA(P,Q), AR(P), or MA(Q).
#' There is support for ARMA11, AR1, MA1, GM, WN, DR, QN, and RW.
#' @keywords internal
#' @export
#' @backref src/ts_model_cpp.cpp
#' @backref src/ts_model_cpp.h
model_objdesc <- function(desc) {
    .Call('_simts_model_objdesc', PACKAGE = 'simts', desc)
}

#' @title Generate the ts model object's theta vector
#' @description Creates the ts.model's theta vector
#' @param desc A \code{vector<string>} that contains a list of the strings of each process.
#' @return A \code{vec} with values initialized at 0 that span the space of parameters to be estimated.
#' @details
#' This function currently does NOT support ARMA(P,Q) models. 
#' That is, there is no support for ARMA(P,Q), AR(P), or MA(Q).
#' There is support for ARMA11, AR1, MA1, GM, WN, DR, QN, and RW.
#' @keywords internal
#' @export
#' @backref src/ts_model_cpp.cpp
#' @backref src/ts_model_cpp.h
model_theta <- function(desc) {
    .Call('_simts_model_theta', PACKAGE = 'simts', desc)
}

#' @title Generate the ts model object's process desc
#' @description Creates the ts.model's process desc
#' @param desc A \code{vector<string>} that contains a list of the strings of each process.
#' @return A \code{vector<string>} with a list of descriptive values to label the estimate matrix with
#' @details
#' This function currently does NOT support ARMA(P,Q) models. 
#' That is, there is no support for ARMA(P,Q), AR(P), or MA(Q).
#' There is support for ARMA11, AR1, MA1, GM, WN, DR, QN, and RW.
#' @keywords internal
#' @export
#' @backref src/ts_model_cpp.cpp
#' @backref src/ts_model_cpp.h
model_process_desc <- function(desc) {
    .Call('_simts_model_process_desc', PACKAGE = 'simts', desc)
}

#' @title Generate eta3 confidence interval
#' @description Computes the eta3 CI
#' @param y          A \code{vec} that computes the brickwalled modwt dot product of each wavelet coefficient divided by their length.
#' @param dims       A \code{String} indicating the confidence interval being calculated.
#' @param alpha_ov_2 A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level 
#' @return A \code{matrix} with the structure:
#' \itemize{
#'  \item{Column 1}{Wavelet Variance}
#'  \item{Column 2}{Chi-squared Lower Bounds}
#'  \item{Column 3}{Chi-squared Upper Bounds}
#' }
#' @keywords internal
ci_eta3 <- function(y, dims, alpha_ov_2) {
    .Call('_simts_ci_eta3', PACKAGE = 'simts', y, dims, alpha_ov_2)
}

#' @title Generate eta3 robust confidence interval
#' @description Computes the eta3 robust CI
#' @param wv_robust   A \code{vec} that computes the brickwalled modwt dot product of each wavelet coefficient divided by their length.
#' @param wv_ci_class A \code{mat} that contains the CI mean, CI Lower, and CI Upper
#' @param alpha_ov_2  A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level
#' @param eff         A \code{double} that indicates the efficiency.
#' @return A \code{matrix} with the structure:
#' \itemize{
#'  \item{Column 1}{Robust Wavelet Variance}
#'  \item{Column 2}{Chi-squared Lower Bounds}
#'  \item{Column 3}{Chi-squared Upper Bounds}
#' }
#' @details
#' Within this function we are scaling the classical 
#' @keywords internal
ci_eta3_robust <- function(wv_robust, wv_ci_class, alpha_ov_2, eff) {
    .Call('_simts_ci_eta3_robust', PACKAGE = 'simts', wv_robust, wv_ci_class, alpha_ov_2, eff)
}

#' @title Generate a Confidence intervval for a Univariate Time Series
#' @description Computes an estimate of the multiscale variance and a chi-squared confidence interval
#' @param signal_modwt_bw A \code{field<vec>} that contains the brick walled modwt or dwt decomposition
#' @param wv              A \code{vec} that contains the wave variance.
#' @param type            A \code{String} indicating the confidence interval being calculated.
#' @param alpha_ov_2      A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level.
#' @param robust          A \code{boolean} to determine the type of wave estimation.
#' @param eff             A \code{double} that indicates the efficiency.
#' @return A \code{matrix} with the structure:
#' \itemize{
#'  \item{Column 1}{Wavelet Variance}
#'  \item{Column 2}{Chi-squared Lower Bounds}
#'  \item{Column 3}{Chi-squared Upper Bounds}
#' }
#' @keywords internal
#' @details 
#' This function can be expanded to allow for other confidence interval calculations.
ci_wave_variance <- function(signal_modwt_bw, wv, type = "eta3", alpha_ov_2 = 0.025, robust = FALSE, eff = 0.6) {
    .Call('_simts_ci_wave_variance', PACKAGE = 'simts', signal_modwt_bw, wv, type, alpha_ov_2, robust, eff)
}

#' @title Generate a Wave Variance for a Univariate Time Series
#' @description Computes an estimate of the wave variance
#' @param signal_modwt_bw A \code{field<vec>} that contains the brick walled modwt or dwt decomposition
#' @param robust          A \code{boolean} to determine the type of wave estimation.
#' @param eff             A \code{double} that indicates the efficiency.
#' @return A \code{vec} that contains the wave variance.
#' @keywords internal
wave_variance <- function(signal_modwt_bw, robust = FALSE, eff = 0.6) {
    .Call('_simts_wave_variance', PACKAGE = 'simts', signal_modwt_bw, robust, eff)
}

#' @title Computes the (MODWT) wavelet variance
#' @description Calculates the (MODWT) wavelet variance
#' @param signal_modwt_bw  A \code{field<vec>} that contains the modwt decomposition after it has been brick walled.
#' @param robust           A \code{boolean} that triggers the use of the robust estimate.
#' @param eff              A \code{double} that indicates the efficiency as it relates to an MLE.
#' @param alpha            A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level 
#' @param ci_type          A \code{String} indicating the confidence interval being calculated. Valid value: "eta3"
#' @return A \code{mat} with the structure:
#' \itemize{
#'   \item{"variance"}{Wavelet Variance}
#'   \item{"low"}{Lower CI}
#'   \item{"high"}{Upper CI}
#' }
#' @keywords internal
#' @details 
#' This function does the heavy lifting with the signal_modwt_bw
wvar_cpp <- function(signal_modwt_bw, robust, eff, alpha, ci_type) {
    .Call('_simts_wvar_cpp', PACKAGE = 'simts', signal_modwt_bw, robust, eff, alpha, ci_type)
}

#' @title Computes the (MODWT) wavelet variance
#' @description Calculates the (MODWT) wavelet variance
#' @param signal     A \code{vec} that contains the data.
#' @param robust     A \code{boolean} that triggers the use of the robust estimate.
#' @param eff        A \code{double} that indicates the efficiency as it relates to an MLE.
#' @param alpha      A \code{double} that indicates the \eqn{\left(1-p\right)\times \alpha}{(1-p)*alpha} confidence level 
#' @param ci_type    A \code{string} indicating the confidence interval being calculated. Valid value: "eta3"
#' @param strWavelet A \code{string} indicating the type of wave filter to be applied. Must be "haar"
#' @param decomp     A \code{string} indicating whether to use "modwt" or "dwt" decomp
#' @return A \code{mat} with the structure:
#' \itemize{
#'   \item{"variance"}{Wavelet Variance}
#'   \item{"low"}{Lower CI}
#'   \item{"high"}{Upper CI}
#' }
#' @keywords internal
#' @details 
#' This function powers the wvar object. It is also extendable...
modwt_wvar_cpp <- function(signal, nlevels, robust, eff, alpha, ci_type, strWavelet, decomp) {
    .Call('_simts_modwt_wvar_cpp', PACKAGE = 'simts', signal, nlevels, robust, eff, alpha, ci_type, strWavelet, decomp)
}

#' @title Computes the MO/DWT wavelet variance for multiple processes
#' @description Calculates the MO/DWT wavelet variance
#' @param signal     A \code{matrix} that contains the same number of observations per dataset
#' @param robust     A \code{boolean} that triggers the use of the robust estimate.
#' @param eff        A \code{double} that indicates the efficiency as it relates to an MLE.
#' @param alpha      A \code{double} that indicates the \eqn{\left(1-p\right)\times \alpha}{(1-p)*alpha} confidence level 
#' @param ci_type    A \code{string} indicating the confidence interval being calculated. Valid value: "eta3"
#' @param strWavelet A \code{string} indicating the type of wave filter to be applied. Must be "haar"
#' @param decomp     A \code{string} indicating whether to use "modwt" or "dwt" decomp
#' @return A \code{field<mat>} with the structure:
#' \itemize{
#'   \item{"variance"}{Wavelet Variance}
#'   \item{"low"}{Lower CI}
#'   \item{"high"}{Upper CI}
#' }
#' @keywords internal
#' @details 
#' This function processes the decomposition of multiple signals quickly
batch_modwt_wvar_cpp <- function(signal, nlevels, robust, eff, alpha, ci_type, strWavelet, decomp) {
    .Call('_simts_batch_modwt_wvar_cpp', PACKAGE = 'simts', signal, nlevels, robust, eff, alpha, ci_type, strWavelet, decomp)
}

#' @title Computes the MODWT scales
#' @description Calculates the MODWT scales
#' @param nb_level  A \code{integer} that contains the level of decomposition J.
#' @return A \code{vec} that contains 2^1, ... , 2^J
#' @keywords internal
#' @details 
#' Used in wvar object.
scales_cpp <- function(nb_level) {
    .Call('_simts_scales_cpp', PACKAGE = 'simts', nb_level)
}

#' @title Quadrature Mirror Filter
#' @description Calculate the series quadrature mirror filter (QMF). Requires a series of an even length.
#' @usage qmf(g, inverse)
#' @param g A \code{vector} that contains the filter constants.
#' @param inverse A \code{bool} that indicates whether the inverse quadrature mirror filter is computed. 
#' By default, the inverse quadrature mirror is computed.
#' @return A \code{vector} that contains either the forward QMF (evalute in order) or the inverse QMF (reverse order). 
#' @author JJB
#' @keywords internal
qmf <- function(g, inverse = TRUE) {
    .Call('_simts_qmf', PACKAGE = 'simts', g, inverse)
}

#' @title Haar filter construction
#' @description Creates the haar filter
#' @usage haar_filter()
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
haar_filter <- function() {
    .Call('_simts_haar_filter', PACKAGE = 'simts')
}

#' @title d4 filter construction
#' @description Creates the d4 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
d4_filter <- function() {
    .Call('_simts_d4_filter', PACKAGE = 'simts')
}

#' @title mb4 filter construction
#' @description Creates the mb4 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
mb4_filter <- function() {
    .Call('_simts_mb4_filter', PACKAGE = 'simts')
}

#' @title w4 filter construction
#' @description Creates the w4 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
w4_filter <- function() {
    .Call('_simts_w4_filter', PACKAGE = 'simts')
}

#' @title fk4 filter construction
#' @description Creates the fk4 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
fk4_filter <- function() {
    .Call('_simts_fk4_filter', PACKAGE = 'simts')
}

#' @title d6 filter construction
#' @description Creates the d6 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
d6_filter <- function() {
    .Call('_simts_d6_filter', PACKAGE = 'simts')
}

#' @title fk6 filter construction
#' @description Creates the fk6 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
fk6_filter <- function() {
    .Call('_simts_fk6_filter', PACKAGE = 'simts')
}

#' @title d8 filter construction
#' @description Creates the d8 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
d8_filter <- function() {
    .Call('_simts_d8_filter', PACKAGE = 'simts')
}

#' @title fk8 filter construction
#' @description Creates the fk8 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
fk8_filter <- function() {
    .Call('_simts_fk8_filter', PACKAGE = 'simts')
}

#' @title la8 filter construction
#' @description Creates the la8 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
la8_filter <- function() {
    .Call('_simts_la8_filter', PACKAGE = 'simts')
}

#' @title mb8 filter construction
#' @description Creates the mb8 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
mb8_filter <- function() {
    .Call('_simts_mb8_filter', PACKAGE = 'simts')
}

#' @title bl14 filter construction
#' @description Creates the bl14 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
bl14_filter <- function() {
    .Call('_simts_bl14_filter', PACKAGE = 'simts')
}

#' @title fk14 filter construction
#' @description Creates the fk14 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
fk14_filter <- function() {
    .Call('_simts_fk14_filter', PACKAGE = 'simts')
}

#' @title d16 filter construction
#' @description Creates the d16 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
d16_filter <- function() {
    .Call('_simts_d16_filter', PACKAGE = 'simts')
}

#' @title la16 filter construction
#' @description Creates the la16 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
la16_filter <- function() {
    .Call('_simts_la16_filter', PACKAGE = 'simts')
}

#' @title mb16 filter construction
#' @description Creates the mb16 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
mb16_filter <- function() {
    .Call('_simts_mb16_filter', PACKAGE = 'simts')
}

#' @title la20 filter construction
#' @description Creates the la20 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
la20_filter <- function() {
    .Call('_simts_la20_filter', PACKAGE = 'simts')
}

#' @title bl20 filter construction
#' @description Creates the bl20 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
bl20_filter <- function() {
    .Call('_simts_bl20_filter', PACKAGE = 'simts')
}

#' @title fk22 filter construction
#' @description Creates the fk22 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
fk22_filter <- function() {
    .Call('_simts_fk22_filter', PACKAGE = 'simts')
}

#' @title mb24 filter construction
#' @description Creates the mb24 filter
#' @return A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details
#' This template can be used to increase the amount of filters available for selection.
#' @author JJB
#' @keywords internal
mb24_filter <- function() {
    .Call('_simts_mb24_filter', PACKAGE = 'simts')
}

#' @title Select the Wavelet Filter
#' @description Constructs the wavelet filter to be used.
#' @usage select_filter(filter_name)
#' @param filter_name A \code{String} that must receive: \code{"haar"}.
#' @return info A \code{field<vec>} that contains:
#' \itemize{
#'  \item{"L"}{A \code{integer} specifying the length of the filter}
#'  \item{"h"}{A \code{vector} containing the coefficients for the wavelet filter}
#'  \item{"g"}{A \code{vector} containing the coefficients for the scaling filter}
#' }
#' @details 
#' The package is oriented toward using only the haar filter. If the package extends at a later time, then the supporting infrastructure is there.
#' @author JJB
#' @keywords internal
select_filter <- function(filter_name = "haar") {
    .Call('_simts_select_filter', PACKAGE = 'simts', filter_name)
}

