% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_reg.r
\name{sim_reg}
\alias{sim_reg}
\title{Master continuous simulation function.}
\usage{
sim_reg(fixed, random, random3, fixed_param, random_param = list(),
  random_param3 = list(), cov_param, k, n, p, error_var, with_err_gen,
  arima = FALSE, data_str, cor_vars = NULL, fact_vars = list(NULL),
  unbal = list(level2 = FALSE, level3 = FALSE), unbal_design = list(level2 =
  NULL, level3 = NULL), lvl1_err_params = NULL, arima_mod = list(NULL),
  contrasts = NULL, homogeneity = TRUE, heterogeneity_var = NULL,
  cross_class_params = NULL, knot_args = list(NULL), ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{random3}{One sided formula for random effects at third level in the 
simulation. Must be a subset of fixed (and likely of random).}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights).
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var = variance of random parameters,
   \item  rand_gen = Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{random_param3}{A list of named elements that must contain: 
\itemize{
    \item random_var = variance of random parameters,
    \item rand_gen = Name of simulation function for random effects.
}
      Optional elements are:
\itemize{
    \item ther: Theorectial mean and variance from rand_gen,
    \item ther_sim: Simulate mean/variance for standardization purposes,
    \item cor_vars: Correlation between random effects,
    \item ...: Additional parameters needed for rand_gen function.
}}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    either 'single', 'level1', 'level2', or 'level3'. 
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{k}{Number of third level clusters.}

\item{n}{Cluster sample size.}

\item{p}{Within cluster sample size.}

\item{error_var}{Scalar of error variance.}

\item{with_err_gen}{Distribution function to pass on to the level one
simulation of errors.}

\item{arima}{TRUE/FALSE flag indicating whether residuals should 
be correlated. If TRUE, must specify a valid model to pass to 
arima.sim via the arima_mod argument. 
See \code{\link{arima.sim}} for examples.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'single', 'level1', 'level2', or 'level3'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A named TRUE/FALSE list specifying whether unbalanced simulation 
design is desired. The named elements must be: "level2" or "level3" representing
unbalanced simulation for level two and three respectively. Default is FALSE,
indicating balanced sample sizes at both levels.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the actual sample sizes within each cluster
can be specified. This takes the form of a vector that must have the same length 
as the level two or three sample size. These are specified as a named list in which
level two sample size is controlled via "level2" and level three sample size is 
controlled via "level3".}

\item{lvl1_err_params}{Additional parameters passed as a list on to the 
level one error generating function}

\item{arima_mod}{A list indicating the ARIMA model to pass to arima.sim. 
See \code{\link{arima.sim}} for examples.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{homogeneity}{Either TRUE (default) indicating homogeneity of variance
assumption is assumed or FALSE to indicate desire to generate heterogeneity 
of variance.}

\item{heterogeneity_var}{Variable name as a character string to use for 
heterogeneity of variance simulation.}

\item{cross_class_params}{A list of named parameters when cross classified 
data structures are desired. Must include the following arguments:
 \itemize{
  \item num_ids: The number of cross classified clusters. These are in 
       addition to the typical cluster ids
  \item random_param: This argument is a list of arguments passed to 
     \code{\link{sim_rand_eff}}. These must include:
    \itemize{
     \item random_var: The variance of the cross classified random effect
     \item rand_gen: The random generating function used to generate the 
        cross classified random effect.
    }
    Optional elements are:
  \itemize{
      \item ther: Theorectial mean and variance from rand_gen,
      \item ther_sim: Simulate mean/variance for standardization purposes,
      \item cor_vars: Correlation between random effects,
      \item ...: Additional parameters needed for rand_gen function.
  } 
 }}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}

\item{...}{Not currently used.}
}
\description{
Takes simulation parameters as inputs and returns simulated data.
}
\details{
Simulated data is useful for classroom demonstrations and to study 
the impacts of assumption violations on parameter estimates, statistical
power, or empirical type I error rates.

This function allows researchers a flexible approach to simulate regression
models, including single level models and cross sectional or longitudinal
linear mixed models (aka. hierarchical linear models or multilevel models).
}
\examples{

# generating parameters for single level regression
fixed <- ~1 + act + diff + numCourse + act:numCourse
fixed_param <- c(2, 4, 1, 3.5, 2)
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'), 
   var_type = c("single", "single", "single"),
   opts = list(list(mean = 0, sd = 4), 
   list(mean = 0, sd = 3),
   list(mean = 0, sd = 3)))
n <- 150
error_var <- 3
with_err_gen <- 'rnorm'
temp_single <- sim_reg(fixed = fixed, fixed_param = fixed_param, 
   cov_param = cov_param, 
   n = n, error_var = error_var, with_err_gen = with_err_gen, 
   data_str = "single")
# Fitting regression to obtain parameter estimates
summary(lm(sim_data ~ 1 + act + diff + numCourse + act:numCourse, 
   data = temp_single))

# Longitudinal linear mixed model example
fixed <- ~1 + time + diff + act + time:act
random <- ~1 + time + diff
fixed_param <- c(4, 2, 6, 2.3, 7)
random_param <- list(random_var = c(7, 4, 2), rand_gen = 'rnorm')
cov_param <- list(dist_fun = c('rnorm', 'rnorm'), 
  var_type = c("level1", "level2"),
  opts = list(list(mean = 0, sd = 1.5), 
  list(mean = 0, sd = 4)))
n <- 150
p <- 30
error_var <- 4
with_err_gen <- 'rnorm'
data_str <- "long"
temp_long <- sim_reg(fixed, random, random3 = NULL, fixed_param, 
   random_param, random_param3 = NULL,
   cov_param, k = NULL, n, p, error_var, with_err_gen, data_str = data_str)

## fitting lmer model
library(lme4)
lmer(sim_data ~ 1 + time + diff + act + time:act + 
  (1 + time + diff | clustID), 
  data = temp_long)

# Three level example
fixed <- ~1 + time + diff + act + actClust + time:act
random <- ~1 + time + diff
random3 <- ~ 1 + time
fixed_param <- c(4, 2, 6, 2.3, 7, 0)
random_param <- list(random_var = c(7, 4, 2), rand_gen = 'rnorm')
random_param3 <- list(random_var = c(4, 2), rand_gen = 'rnorm')
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'), 
     var_type = c("level1", "level2", "level3"),
     opts = list(list(mean = 0, sd = 1.5),
     list(mean = 0, sd = 4),
     list(mean = 0, sd = 2)))
k <- 10
n <- 15
p <- 10
error_var <- 4
with_err_gen <- 'rnorm'
data_str <- "long"
temp_three <- sim_reg(fixed, random, random3, fixed_param, random_param, 
random_param3, cov_param, k,n, p, error_var, with_err_gen, 
   data_str = data_str)

library(lme4)
lmer(sim_data ~ 1 + time + diff + act + actClust + time:act + 
   (1 + time + diff | clustID) +  
   (1 | clust3ID), data = temp_three)

}
