% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/where_het.R
\name{where_het}
\alias{where_het}
\title{Find heterozygous regions}
\usage{
where_het(ind)
}
\arguments{
\item{ind}{An individual object, as output be
\code{\link[=create_parent]{create_parent()}} or \code{\link[=cross]{cross()}}}
}
\value{
A matrix with two columns; each row indicates the start and
end of a region where the individual is heterozygous
}
\description{
Find regions of heterozygosity in an individual
}
\examples{
mom <- create_parent(100, 1:2)
dad <- create_parent(100, 1:2)
child <- cross(mom, dad)
where_het(child)
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}},
\code{\link[=convert2geno]{convert2geno()}}
}
