% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_eta_matrix}
\alias{sim_eta_matrix}
\title{Generate ideal response \eqn{\eta} Matrix}
\usage{
sim_eta_matrix(K, J, Q)
}
\arguments{
\item{K}{Number of Attribute Levels}

\item{J}{Number of Assessment Items}

\item{Q}{Q Matrix with dimensions \eqn{K \times J}{K x J}.}
}
\value{
A \code{mat} with dimensions \eqn{J \times 2^K}{J x 2^K}.
}
\description{
Creates the ideal response matrix for each trait
}
\examples{
## Simulation Settings ----

# Fixed Number of Assessment Items for Q
J = 18

# Fixed Number of Attributes for Q
K = 3

## Pre-specified configuration ----

# Specify Q
qbj = c(4, 2, 1, 4, 2, 1, 4, 2, 1, 6, 5, 3, 6, 5, 3, 7, 7, 7)

# Fill Q Matrix
Q = matrix(, J, K)
for (j in seq_len(J)) {
  Q[j,] = attribute_inv_bijection(K, qbj[j])
}

# Create an eta matrix
ETA = sim_eta_matrix(K, J, Q)

## Random generation of Q matrix with ETA matrix ----

# Construct a random q matrix
Q_sim = sim_q_matrix(J, K)

# Generate the eta matrix
ETA_gen = sim_eta_matrix(K, J, Q_sim)
}
\seealso{
\code{\link[simcdm:sim_q_matrix]{simcdm::sim_q_matrix()}}, \code{\link[simcdm:attribute_bijection]{simcdm::attribute_bijection()}}, and
\code{\link[simcdm:attribute_inv_bijection]{simcdm::attribute_inv_bijection()}}
}
\author{
Steven Andrew Culpepper and James Joseph Balamuta
}
