% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simulation.r
\name{simfull}
\alias{simfull}
\title{Simulate Full Data (From Action/Intervention DAG(s))}
\usage{
simfull(actions, n, wide = TRUE, LTCF = NULL, rndseed = NULL)
}
\arguments{
\item{actions}{Actions specifying the counterfactual DAG. This argument must be either an object of class DAG.action or a list of DAG.action objects.}

\item{n}{Number of observations to sample.}

\item{wide}{A logical, if TRUE the output data is generated in wide format, if FALSE, the output longitudinal data in generated in long format}

\item{LTCF}{The name of the right-censoring / failure event indicator variable for the Last Time-point Carried Forward imputation. By default, when LTCF is left unspecified, all variables that follow after any end of follow-up (EFU) event are set to missing (NA). The end of follow-up event occurs when a binary node declared with EFU=TRUE is observed to be equal to 1, indicating a failing or right-censoring event. To forward impute the values of the time-varying nodes after the occurrence of the EFU event, set the LTCF argument to a name of the EFU node representing this event. This implies that for each observation, missing value of a time-varying variable (that is node declared with t argument) will be replaced by the last observed value of that variable, if the missingness is a result of the EFU event of the node LTCF.}

\item{rndseed}{Seed for the random number generator.}
}
\value{
A named list, each item is a \code{data.frame} corresponding to an action specified by the actions argument, action names are used for naming these list items.
}
\description{
This function simulates full data based on a list of intervention DAGs, returning a list of \code{data.frames}
}

