% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGG.simpoly.R
\name{simGG.simpoly}
\alias{simGG.simpoly}
\title{Plot simulated polynomial quantities of interest from Cox Proportional
Hazards Models}
\usage{
\method{simGG}{simpoly}(obj, from = NULL, to = NULL, rug = TRUE,
  rug_position = "identity", xlab = NULL, ylab = NULL, title = NULL,
  method = "auto", spalette = "Set1", legend = "legend", leg.name = "",
  lcolour = "#2B8CBE", lsize = 1, pcolour = "#A6CEE3", psize = 1,
  alpha = 0.2, type = "ribbons", ...)
}
\arguments{
\item{obj}{a \code{simpoly} class object.}

\item{from}{numeric time to start the plot from. Only relevant if
\code{qi = "Hazard Rate"}.}

\item{to}{numeric time to plot to. Only relevant if
\code{qi = "Hazard Rate"}.}

\item{rug}{logical indicating whether or not to include a rug plot showing
the distribution of values in the sample used to estimate the \code{coxph}
model. Only relevant when the quantity of interest is not
\code{"Hazard Rate"}.}

\item{rug_position}{character string. The position adjustment to use for
overlapping points in the rug plot. Use \code{"jitter"} to jitter the points.}

\item{xlab}{a label for the plot's x-axis.}

\item{ylab}{a label of the plot's y-axis. The default uses the value of
\code{qi}.}

\item{title}{the plot's main title.}

\item{method}{what type of smoothing method to use to summarize the center
of the simulation distribution.}

\item{spalette}{colour palette for when there are multiple sets of
comparisons to plot. Default palette is \code{"Set1"}. See
\code{\link{scale_colour_brewer}}.}

\item{legend}{specifies what type of legend to include (if applicable). The
default is \code{legend = "legend"}. To hide the legend use
\code{legend = FALSE}. See the \code{\link{discrete_scale}} for more details.}

\item{leg.name}{name of the legend (if applicable).}

\item{lcolour}{character string colour of the smoothing line. The default is
hexadecimal colour \code{lcolour = '#2B8CBE'}. Only relevant if
\code{qi = "First Difference"}.}

\item{lsize}{size of the smoothing line. Default is 1. See
\code{ggplot2}.}

\item{pcolour}{character string colour of the simulated points or ribbons
(when there are not multiple sets of simulations). Default is hexadecimal
colour \code{pcolour = '#A6CEE3'}.}

\item{psize}{size of the plotted simulation points. Default is
\code{psize = 1}. See \code{ggplot2}.}

\item{alpha}{numeric. Alpha (e.g. transparency) for the points, lines, or
ribbons. Default is \code{alpha = 0.2}. See \code{ggplot2}. Note, if
\code{type = "lines"} or \code{type = "points"} then \code{alpah} sets the
maximum value per line or point at the center of the distribution. Lines or
points further from the center are more transparent the further they get
from the middle.}

\item{type}{character string. Specifies how to plot the simulations. Can be
\code{points}, \code{lines}, or \code{ribbons}. If points then each
simulation value will be plotted. If \code{lines} is chosen then each
simulation is plotted using a different line. Note: any simulation with a
value along its length that is outside of the specified central interval
will be dropped. This is to create a smooth plot. If \code{type = "ribbons"}
a plot will be created with shaded areas ('ribbons') for the minimum and
maximum simulation values (i.e. the middle interval set with \code{qi} in
\code{\link{coxsimSpline}}) as well as the central 50 percent of this area.
It also plots a line for the median value of the full area, so values in
\code{method} are ignored. One of the key advantages of using ribbons
rather than points is that it creates plots with smaller file sizes.}

\item{...}{Additional arguments. (Currently ignored.)}
}
\value{
a \code{gg} \code{ggplot} class object
}
\description{
\code{simGG.simpoly} uses ggplot2 to plot simulated relative
quantities of interest from a \code{simpoly} class object.
}
\details{
Uses ggplot2 to plot the quantities of interest from
\code{simpoly} objects.
}
\examples{
# Load Carpenter (2002) data
data("CarpenterFdaData")

# Load survival package
library(survival)

# Run basic model
M1 <- coxph(Surv(acttime, censor) ~ prevgenx + lethal +
       deathrt1 + acutediz + hosp01  + hhosleng + mandiz01 +
       femdiz01 + peddiz01 + orphdum + natreg +
       I(natreg^2) + I(natreg^3) + vandavg3 + wpnoavg3 +
       condavg3 + orderent + stafcder, data = CarpenterFdaData)

# Simulate simpoly First Difference
Sim1 <- coxsimPoly(M1, b = "natreg", qi = "First Difference",
           pow = 3, Xj = seq(1, 150, by = 5), nsim = 100)

# Plot simulations
simGG(Sim1, rug_position = 'jitter')

\dontrun{
# Simulate simpoly Hazard Ratio with spin probibility interval
Sim2 <- coxsimPoly(M1, b = "natreg", qi = "Hazard Ratio",
          pow = 3, Xj = seq(1, 150, by = 5), spin = TRUE,
          nsim = 100)

# Plot simulations
simGG(Sim2, type = 'ribbons', rug_position = 'jitter')

Sim3 <- coxsimPoly(M1, b = "natreg", qi = "Hazard Rate",
           pow = 3, Xj = c(1, 150), nsim = 100)

# Plot simulations
simGG(Sim3, type = 'lines')
}

}
\references{
Gandrud, Christopher. 2015. simPH: An R Package for Illustrating
Estimates from Cox Proportional Hazard Models Including for Interactive and
Nonlinear Effects. Journal of Statistical Software. 65(3)1-20.
}
\seealso{
\code{\link{coxsimPoly}} and \code{ggplot2}
}
