% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vfd}
\alias{vfd}
\title{Variate Generation for FALSE Distribution}
\usage{
vfd(n, df1, df2, ncp = 0, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{df1}{Degrees of freedom > 0}

\item{df2}{Degrees of freedom > 0}

\item{ncp}{Non-centrality parameter >= 0}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via 
\code{\link[=qf]{stats::qf}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qf]{stats::qf}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

  Otherwise, return a list with components suitable for visualizing inversion,
  specifically:
    \item{u}{        A vector of generated U(0,1) variates }
    \item{x}{        A vector of FALSE random variates }
    \item{quantile}{ Parameterized quantile function }
    \item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for FALSE Distribution
}
\details{
Generates random variates from the FALSE distribution.

  FALSE variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
  (if \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qf]{stats::qf}} is used to
  invert the uniform(0,1) variate(s).
  In this way, using \code{vfd} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

The F distribution with \code{df1} \eqn{= n_1}{= n1} and \code{df2}
   \eqn{= n_2}{= n2} degrees of freedom has density

   \deqn{f(x) = \frac {\Gamma(n_1/2 + n_2/2)} {\Gamma(n_1/2) \ \Gamma(n_2/2)}
                \left( \frac{n_1}{n_2} \right)^{n_1/2} x^{n_1/2 - 1}
                \left( 1 + \frac{n_1x}{n_2} \right) ^ {-(n_1 + n_2)/2}}{%
         f(x) = Gamma((n1 + n2)/2) / (Gamma(n1/2) Gamma(n2/2)) (n1/n2)^(n1/2)
                x^(n1/2 - 1) (1 + (n1/n2) x)^-(n1 + n2)/2}

   for \eqn{x > 0}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qf
 vfd(3, df1 = 1, df2 = 2, ncp = 10)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qf
 vfd(3, 5, 5, stream = 1)
 vfd(3, 5, 5, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qf
 vfd(1, 5, 5, stream = 1)
 vfd(1, 5, 5, stream = 2)
 vfd(1, 5, 5, stream = 1)
 vfd(1, 5, 5, stream = 2)
 vfd(1, 5, 5, stream = 1)
 vfd(1, 5, 5, stream = 2)

 set.seed(8675309)
 variates <- vfd(1000, 5, 5, stream = 1)
 set.seed(8675309)
 variates <- vfd(1000, 5, 5, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
         \code{\link[=runif]{stats::runif}}

\code{\link[=rf]{stats::rf}}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{random variate generation}
\keyword{distribution}
