% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_soilHeatFlux_hourly}
\alias{cal_soilHeatFlux_hourly}
\title{Calculating soil heat flux(G) for hourly/shorter periods}
\usage{
cal_soilHeatFlux_hourly(Rn, periods)
}
\arguments{
\item{Rn}{net radiation.From cal_netRadiation().}

\item{periods}{"daylight" or "nighttime".}
}
\value{
A vector for soil heat flux [MJ m-2 day-1]
}
\description{
For hourly (or shorter) calculations, G beneath a dense cover
   of grass does not correlate well with air temperature.
}
\note{
Where the soil is warming, the soil heat flux G is positive. The amount
   of energy required for this process is subtracted from Rn when estimating
   evapotranspiration.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
