% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showtext.R
\name{showtext.begin}
\alias{showtext.begin}
\title{Rendering Text for R Graphics Devices}
\usage{
showtext.begin()
}
\description{
Calling this function will use \pkg{showtext} to render text
for the current graphics device. The main advantage of
\pkg{showtext} is that user can use any supported font file for
the text rendering, and text glyphs will be converted
into polygons (for vector graphics) or raster images
(for bitmap and on-screen graphics),
thus producing device independent output on all platforms.
This function would be useful if you want to use non-standard fonts
in the graphics device. The usage of this function is easy:
simply open the graphics device, and "claim" that you want to use
\pkg{showtext} by calling this function.
See the \strong{Examples} section for details.
}
\details{
This package uses FreeType to load font files and render
         text characters. The font loading part is done by function
         \code{\link[sysfonts]{font.add}()} in the \pkg{sysfonts}
         package. Users could read the help page of
         \code{\link[sysfonts]{font.paths}()},
         \code{\link[sysfonts]{font.files}()} and
         \code{\link[sysfonts]{font.add}()} to learn how to load
         a font file into R. \pkg{showtext} package
         has a built-in font file of the WenQuanYi Micro Hei
         family, and it will be loaded automatically, so users can
         use this function directly without any extra settings.
         
         The mechanism of this function is that it can replace the
         text rendering functions contained in the current device.
         \pkg{showtext} will first use FreeType to analyze the
         outline of each character in the text, and then call some
         low-level drawing functions in the current device to draw
         the glyph. As a result, glyphs of the text will be finally
         converted into polygons or raster images, which means that
         the system where the graph is viewed does not need to install
         the fonts that create the graph.
         
         Notice that this function is only effective to the current
         \strong{ACTIVE} device. So to use this function, the device
         you want to work with must have already been opened (through
         functions like \code{\link[grDevices]{png}()},
         \code{\link[grDevices]{pdf}()}, etc.).
         
         To switch back, users can call \code{\link{showtext.end}()}
         to restore the original device functions. See examples
         below for the usage of these functions.
}
\examples{
\dontrun{
old = setwd(tempdir())

###  Enable pdf() to draw Chinese characters nicely  ###
###  Requires the simkai.ttf font file, usually      ###
###  installed in Windows                            ###

## First, open the device
pdf("showtext-ex1.pdf")

## For now we are using the original device functions to draw axis labels
plot(1, type = "n")

## Then turn showtext on and draw some characters
showtext.begin()
text(1, 1.2, intToUtf8(c(21315, 31179, 19975, 36733)), cex = 5)

## Use another font
if("simkai.ttf" \%in\% font.files()) font.add("kaishu", "simkai.ttf")
text(1, 0.8, intToUtf8(c(19968, 32479, 27743, 28246)),
     cex = 5, family = "kaishu")
     
## Turn showtext off
showtext.end()

## Also turn off the device
dev.off()


###  Download font file from web  ###

download.file("http://fontpro.com/download-family.php?file=36289",
              "newrocker.ttf", mode="wb")
download.file("http://fontpro.com/download-family.php?file=35128",
              "cutetumblr.ttf", mode ="wb")

font.add("newrocker", "newrocker.ttf")
font.add("cutetumblr", "cutetumblr.ttf")

png("showtext-ex2.png", 800, 500)
plot(1, type = "n")
showtext.begin()
text(1, 1.2, "Let me tell you a story", cex = 4, family = "newrocker")
text(1, 0.8, "Long long ago...", cex = 4, family = "cutetumblr")
showtext.end()
dev.off()

setwd(old)

}
}
\author{
Yixuan Qiu <\url{http://statr.me/}>
}
\seealso{
\code{\link{showtext.opts}()}, \code{\link{showtext.auto}()},
         \code{\link{showtext.end}()}
}

