% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize_data.R
\name{organize_data}
\alias{organize_data}
\alias{organize_data.default}
\alias{organize_data.tune_results}
\title{Extract data from objects to use in a shiny app}
\usage{
organize_data(x, hover_cols = NULL, ...)

\method{organize_data}{default}(x, hover_cols = NULL, ...)

\method{organize_data}{tune_results}(x, hover_cols = NULL, ...)
}
\arguments{
\item{x}{The \code{\link[tune:fit_resamples]{tune::fit_resamples()}} result.}

\item{hover_cols}{The columns to display while hovering.}

\item{...}{Other parameters not currently used.}
}
\value{
A list with elements data frame and character vectors. The data frame includes
an outcome variable \code{.outcome}, a prediction variable \code{.pred}, model
configuration variable \code{.config}, and hovering columns \code{.hover}.
}
\description{
This function joins the result of \code{\link[tune:fit_resamples]{tune::fit_resamples()}}  to the original
dataset to give a list that can be an input for the Shiny app.
}
\details{
The default configuration is based on \strong{the optimal value} of the first metric.
}
\keyword{internal}
