% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{custom-labels}
\alias{custom-labels}
\alias{set_labels}
\alias{get_labels}
\title{Modify {shinymanager} labels to use custom text}
\usage{
set_labels(language, ...)

get_labels(language = "en")
}
\arguments{
\item{language}{Language to use for labels, supported values are : "en", "fr", "pt-BR", "es", "de", "pl".}

\item{...}{A named list with labels to replace.}
}
\value{
\code{get_labels()} return a named list with all labels registered.
}
\description{
See all labels registered with \code{get_labels()},
 then set custom text with \code{set_labels()}.
}
\examples{

# In global.R for example:
set_labels(
  language = "en",
  "Please authenticate" = "You have to login",
  "Username:" = "What's your name:",
  "Password:" = "Enter your password:"
)
}
