% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback-wrappers.R
\name{feedbackWarning}
\alias{feedbackWarning}
\title{feedbackWarning}
\usage{
feedbackWarning(inputId, condition, text = "Ye be warned",
  color = "#F89406", icon = shiny::icon("warning-sign", lib = "glyphicon"))
}
\arguments{
\item{inputId}{the Shiny input's \code{inputId} argument}

\item{condition}{condition under which feeback is displayed}

\item{text}{default \code{"Ye be warned"} text string to display below input}

\item{color}{defailt \code{"#F89406"} the color of the feeback}

\item{icon}{default \code{icon("warning-sign", lib="glyphicon"))} a \code{shiny::icon} object}
}
\description{
wrapper for \code{feedback()} function that displays a
warning message by default
}
\examples{

## Only run examples in interacive R sessions
if (interactive()) {
  ui <- fluidPage(
    useShinyFeedback(),
    
    numericInput(
      "exampleInput",
      "Show Feedback When < 0",
      value = -5
    )
  )
  
  server <- function(input, output) {
    observeEvent(input$exampleInput, {
      feedbackWarning(
        "exampleInput",
        condition = input$exampleInput < 0
      )
    })
  }
  
  shinyApp(ui, server)
}

}
\seealso{
\code{\link{feedback}}, \code{\link{feedbackDanger}}, \code{\link{feedbackSuccess}}

Other feedback.wrappers: \code{\link{feedbackDanger}},
  \code{\link{feedbackSuccess}}
}

