% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_test.R
\name{log_test}
\alias{log_test}
\title{Logging unit test}
\usage{
log_test(..., type = "TEST", params = NULL)
}
\arguments{
\item{...}{An unit test function call that is evaluated and logged.}

\item{type}{A character string. A type of the event.
Default for \code{log_test} is \code{"TEST"}.}

\item{params}{A list of additional named event-specific parameters.
Default is \code{NULL}.}
}
\description{
\code{log_test} logs a unit test
which can be built in inside a shiny app.
The event logged has status \code{SUCCESS}
or \code{ERROR} if the unit test does not pass successfully.
The error status is logged silently and does not stops
the shiny app from running by itself.
The error message is logged in a log entry body.
Deparsed unit test function call is logged
as an event name in a log entry header.
}
\examples{
\donttest{
if (interactive()) {
  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session()
      log_test(testthat::expect_true(TRUE))
      log_test(testthat::expect_true(FALSE))
    }
  )
}
}
}
\seealso{
Other logging events functions: \code{\link{log_event}},
  \code{\link{log_message}}, \code{\link{log_output}},
  \code{\link{log_started}}, \code{\link{log_value}}
}
\concept{logging events functions}
