% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jseval_and_hooks.R
\name{useClipboard}
\alias{useClipboard}
\title{The `useClipboard` hook}
\usage{
useClipboard(value)
}
\arguments{
\item{value}{a string}
}
\value{
A list containing some URL-encoded JavaScript code.
}
\description{
The `useClipboard` hook.
}
\details{
See \href{https://chakra-ui.com/docs/hooks/use-clipboard}{useClipboard}.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    withStates(
      Tag$Box(
        width = "50\%",

        Tag$Flex(
          mb = 2,
          Tag$Input(
            isReadOnly = TRUE,
            value = getHookProperty("clipboard", "value")
          ),
          Tag$Button(
            ml = 2,
            onClick = getHookProperty("clipboard", "onCopy"),
            jseval('getState("hasCopied") ? "Copied" : "Copy"')
          )
        ),

        br(),
        Tag$Divider(),
        br(),

        Tag$Editable(
          bg = "yellow.100",
          placeholder = "Paste here",
          Tag$EditablePreview(),
          Tag$EditableInput()
        )

      ),

      states = list(
        clipboard = useClipboard("Hello Chakra"),
        hasCopied = getHookProperty("clipboard", "hasCopied")
      )
    )

  )

)

server <- function(input, output, session){}

if(interactive()){
  shinyApp(ui, server)
}
}
\seealso{
\code{\link{getHookProperty}}
}
