% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraCombinedSlider.R
\name{chakraCombinedSlider}
\alias{chakraCombinedSlider}
\title{Combined slider and number input}
\usage{
chakraCombinedSlider(
  id,
  value,
  min,
  max,
  step = NULL,
  maxWidth = "400px",
  numericInputOptions = numberInputOptions(),
  spacing = "2rem",
  keepWithinRange = TRUE,
  clampValueOnBlur = TRUE,
  focusThumbOnChange = FALSE,
  trackColor = NULL,
  filledTrackColor = NULL,
  tooltip = TRUE,
  tooltipOptions = sliderTooltipOptions(),
  thumbOptions = sliderThumbOptions(),
  ...
)
}
\arguments{
\item{id}{widget id}

\item{value}{initial value}

\item{min}{minimal value}

\item{max}{maximal value}

\item{step}{increment step}

\item{maxWidth}{slider width}

\item{numericInputOptions}{list of options for the number input created with
\code{\link{numberInputOptions}}}

\item{spacing}{the space between the number input and the slider}

\item{keepWithinRange}{whether to forbid the value to exceed the max or go
lower than min}

\item{clampValueOnBlur}{similar to \code{keepWithinRange}}

\item{focusThumbOnChange}{whether to focus the thumb on change}

\item{trackColor}{color of the slider track}

\item{filledTrackColor}{color of the filled slider track}

\item{tooltip}{whether to set a tooltip to the thumb, to show the value}

\item{tooltipOptions}{options of the tooltip, a list created with
\code{\link{sliderTooltipOptions}}}

\item{thumbOptions}{list of options for the thumb created with
\code{\link{sliderThumbOptions}}}

\item{...}{other attributes passed to \code{Slider}}
}
\value{
A widget to use in \code{\link{chakraComponent}}.
}
\description{
A widget combining a slider and a number input.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(), br(),

  chakraComponent(
    "mycomponent",

    chakraCombinedSlider(
      "slider",
      value = 5,
      min = 0,
      max = 10,
      step = 0.5,
      maxWidth = "300px",
      tooltip = TRUE,
      trackColor = "green.300",
      thumbOptions = sliderThumbOptions(
        width = 20, height = 20,
        borderColor = "firebrick", borderWidth = "3px"
      )
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["slider"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
