% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizHillslopePosition.R
\name{vizHillslopePosition}
\alias{vizHillslopePosition}
\title{Visual Summary of Hillslope Position}
\usage{
vizHillslopePosition(x, s = NULL, annotations = TRUE, annotation.cex = 0.75)
}
\arguments{
\item{x}{\code{data.frame} as created by \code{soilDB::fetchOSD(..., extended=TRUE)}, see details}

\item{s}{an optional soil series name, highlighted in the figure}

\item{annotations}{logical, add number of record and normalized Shannon entropy values}

\item{annotation.cex}{annotation label scaling factor}
}
\value{
a \code{list} with the following elements:

\item{fig}{lattice object (the figure)}
\item{order}{ordering of soil series}
}
\description{
A unique display of hillslope position probability.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{Soil Series Query Functions} tutorial for more information.
}
\examples{

\donttest{
if(requireNamespace("curl") &
   curl::has_internet() &
   require(aqp) & 
   require(soilDB)) {
  
  # soils of interest
  s.list <- c('musick', 'cecil', 'drummer', 'amador', 'pentz', 'reiff', 
              'san joaquin','montpellier','grangeville','pollasky','ramona')
  
  # fetch and convert data into an SPC
  s <- fetchOSD(s.list, extended=TRUE)
  
  res <- vizHillslopePosition(s$hillpos)
  print(res$fig)
  
}
}

}
\author{
D.E. Beaudette
}
