% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSS2LL.R
\name{formatPLSS}
\alias{formatPLSS}
\title{formatPLSS}
\usage{
formatPLSS(p, type = "SN")
}
\arguments{
\item{p}{data.frame with chunks of PLSS coordinates}

\item{type}{an option to format protracted blocks 'PB', unprotracted blocks 'UP', or standard section number 'SN' (default).}
}
\value{
A vector of PLSS codes.
}
\description{
Format PLSS information into a coded format that can be digested by PLSS web service.
}
\details{
This function is typically accessed as a helper function to prepare data for use within \code{\link{PLSS2LL}} function.
}
\note{
This function expects that the \code{Polygon} object has coordinates associated with a projected CRS-- e.g. units of meters.

This function requires the following packages: \code{stringi}.
}
\examples{
# create some data
d <- data.frame(
  id = 1:3,
  qq = c('SW', 'SW', 'SE'),
  q = c('NE', 'NW', 'SE'),
  s = c(17, 32, 30),
  t = c('T36N', 'T35N', 'T35N'),
  r = c('R29W', 'R28W', 'R28W'),
  type = 'SN',
  m = 'MT20',
  stringsAsFactors = FALSE
)
# add column names

names(d) <- c('id', 'qq', 'q', 's', 't', 'r', 'type', 'm')
# generate formatted PLSS codes
formatPLSS(d, type='SN')
}
\seealso{
\code{\link{PLSS2LL}}
}
\author{
D.E. Beaudette, Jay Skovlin
}
