% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{memory_layer}
\alias{memory_layer}
\title{A \code{\link[torch:nn_module]{torch::nn_module()}} Representing a Memory Layer}
\usage{
memory_layer(id, shared_env, output = FALSE, add = FALSE, verbose = FALSE)
}
\arguments{
\item{id}{A unique id to use as a key in the storage list.}

\item{shared_env}{A shared environment for all instances of memory_layer where the inputs are stored.}

\item{output}{Boolean variable indicating if the memory layer is to store input in storage or extract from storage.}

\item{add}{Boolean variable indicating if the extracted value are to be added or concatenated to the input.
Only applicable when \code{output = TRUE}.}

\item{verbose}{Boolean variable indicating if we want to give printouts to the user.}
}
\description{
The layer is used to make skip-connections inside a \code{\link[torch:nn_sequential]{torch::nn_sequential()}} network
or between several \code{\link[torch:nn_sequential]{torch::nn_sequential()}} networks without unnecessary code complication.
}
\details{
If \code{output = FALSE}, this layer stores its input in the \code{shared_env} with the key \code{id} and then
passes the input to the next layer. I.e., when memory layer is used in the masked encoder. If \code{output = TRUE}, this
layer takes stored tensor from the storage. I.e., when memory layer is used in the decoder. If \code{add = TRUE}, it
returns sum of the stored vector and an \code{input}, otherwise it returns their concatenation. If the tensor with
specified \code{id} is not in storage when the layer with \code{output = TRUE} is called, it would cause an exception.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
