% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{setFilter}
\alias{setFilter}
\title{Set a filter to analyze the shape data}
\usage{
setFilter(object, filter)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{filter}{A vector restricting the new filter value. Only otoliths having shape parameters are selected.}
}
\value{
A \code{\linkS4class{shapeR}} object with the slot \code{filter} set.
}
\description{
Sets a filter on \code{master.list}. Here it is possible to filter the \code{master.list} by specific ages, maturity stages, areas, etc.
If no value is set, all data with shape parameters are used
}
\examples{
data(otoliths)
#Filter only Icelandic and Norwegian samples
shape = setFilter(shape,
getMasterlist(shape, useFilter = FALSE)$pop \%in\% c("NO","IC"))
table(getMasterlist(shape)$pop)
#Reset filter
shape = setFilter(shape)
table(getMasterlist(shape)$pop)
}
\author{
Lisa Anne Libungan
}

