% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorMat.R
\name{genCorMat}
\alias{genCorMat}
\title{Correlation Matrix Generator.}
\usage{
genCorMat(corstr = "independence", rho, maxClusterSize = 0)
}
\arguments{
\item{corstr}{Structure of correlaiton matrix to be generated;
'independence', 'exchangeable', 'ar1', and 'unstructured' currently
implemented.}

\item{rho}{Correlation parameter; assumed to be of length 1 or
\code{maxClusterSize * (maxClusterSize - 1) /2}.}

\item{maxClusterSize}{size of the correlation matrix being generated.}
}
\value{
A correlation matrix of form matching corstr and of size
maxClusterSize.
}
\description{
Function that generates a correlation matrix of a predefined type  and size
given appropriate correlation parameter(s), \code{rho}.
}
\note{
Mostly intended for internal use, but could be useful to user.
Therefore, the function is exported.
}
\examples{


## Generates Correlation Matricies easily
## When corstr = "independence", the value of rho
## is irrelevant
mat1 <- genCorMat(corstr = "independence", rho = .1, maxClusterSize = 3) 

## Exchangeable
mat2 <- genCorMat(corstr = "exchangeable", rho = .3, maxClusterSize = 2) 

## AR-1
mat3 <- genCorMat(corstr = "ar1", rho = .4, maxClusterSize = 4) 

## unstructured
mat3 <- genCorMat(corstr = "unstructured",
                  rho = c(.3,.2,.1),
                  maxClusterSize = 3) 


}
\author{
Gregory Vaughan
}
