% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genData.R
\name{genData}
\alias{genData}
\title{Response and  Covariate Data Generation}
\usage{
genData(numClusters, clusterSize, clusterRho, clusterCorstr = "exchangeable",
  yVariance = NULL, xVariance, numGroups, groupSize, groupRho, beta,
  family = gaussian(), SNR = NULL, intercept = 0)
}
\arguments{
\item{numClusters}{Number of clusters to be generated.}

\item{clusterSize}{Size of each cluster.}

\item{clusterRho}{Correlation parameter for response.}

\item{clusterCorstr}{String indicating cluster Correlation structure.
Parameter is fed to \code{genCorMat},
so all possible entries for \code{genCorMat} are allowed.}

\item{yVariance}{Optional scalar value specifying the marginal response
variance; overrides \code{SNR}.}

\item{xVariance}{Scalar value indicating marginal variance of the
covariates.}

\item{numGroups}{Number of covariate groups to be generated.}

\item{groupSize}{Size of each group.}

\item{groupRho}{Within group correlation parameter.}

\item{beta}{Vector of coefficient values used to generate response.}

\item{family}{Marginal response family; currently \code{gaussian()} and
\code{poisson()} are accepted.}

\item{SNR}{Scalar value that allows fixing the signal
to noise ratio as defined as the ratio of the variance in the
linear predictor to the variance of the response conditioned on the
covariates.}

\item{intercept}{Scalar value indicating the true intercept value.}
}
\value{
List containing the generated response, \code{y}, the generated
covariates, \code{x}, a vector identifying the responses clusters,
\code{clusterID}, and a vector identifying the covariate groups,
\code{groupID}.
}
\description{
Function to generate data that can be used to test Forward stagewise /
Penalized Regression techniques. Currently marginally Gaussian and
Poisson responses are possible.
 
Function is provided to allow the user simple data generation as
\code{bisee} and \code{hisee} were designed for.
Various parameters controlling
aspects such as the response correlation, the covariate group
structure, the marginal response distribution, and the signal to
noise ratio for marginally gaussian responses are
provided to allow a great deal of specificity over the kind of data
that is generated.
}
\note{
Function is ued to generate both the desired covariate structure and
the desired response structure. To generate poisson responses, functions
from the R package \code{coupla} are used.
}
\examples{


## A resonse variance can be given,
dat1 <- genData(numClusters = 10,
                clusterSize = 4,
                clusterRho = .5,
                clusterCorstr = "exchangeable",
                yVariance = 1,
                xVariance = 1,
                numGroups = 5,
                groupSize = 4,
                groupRho = .5,
                beta = c(rep(1,8), rep(0,12)),
                family = gaussian(),
                intercept = 1)

## or the signal to noise ratio can be fixed
dat2 <- genData(numClusters = 10,
                clusterSize = 4,
                clusterRho = .5,
                clusterCorstr = "exchangeable",
                xVariance = 1,
                numGroups = 5,
                groupSize = 4,
                groupRho = .5,
                beta = c(rep(1,8), rep(0,12)),
                family = gaussian(),
                SNR = 10,
                intercept = 1)

}
\author{
Gregory Vaughan
}

