% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sf_remove_holes}
\alias{sf_remove_holes}
\title{remove holes}
\usage{
sf_remove_holes(obj, close = TRUE)
}
\arguments{
\item{obj}{sfg, sfc or sf object.}

\item{close}{logical indicating whether polygons should be closed. If \code{TRUE},
all polygons will be checked and force closed if possible}
}
\description{
Removes holes from olygons and multipolygons. Points and linestrings are unaffected.
}
\examples{
df <- data.frame(
  ml_id = c(1,1,1,1,1,1,1,1,1,2,2,2,2,2,2)
  , l_id = c(1,1,1,2,2,2,3,3,3,1,1,1,2,2,2)
  , x = rnorm(15)
  , y = rnorm(15)
  , z = rnorm(15)
  , m = rnorm(15)
)

sfg <- sfg_polygon( obj = df, x = "x", y = "y", linestring_id = "ml_id" )
sfc <- sfc_polygon( obj = df, x = "x", y = "y", polygon_id = "ml_id", linestring_id = "l_id" )
sf <- sf_polygon( obj = df, x = "x", y = "y", polygon_id = "ml_id", linestring_id = "l_id" )

sf_remove_holes( sfg )
sf_remove_holes( sfc )
sf_remove_holes( sf )

}
