% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/funs.groupfs.R
\name{groupfs}
\alias{groupfs}
\title{Select a model with forward stepwise.}
\usage{
groupfs(x, y, index, maxsteps, sigma = NULL, k = 2, intercept = TRUE,
  normalize = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{Matrix of predictors (n by p).}

\item{y}{Vector of outcomes (length n).}

\item{index}{Group membership indicator of length p.}

\item{maxsteps}{Maximum number of steps for forward stepwise.}

\item{sigma}{Estimate of error standard deviation for use in AIC criterion. This determines the relative scale between RSS and the degrees of freedom penalty. Default is NULL corresponding to unknown sigma. See \code{\link{extractAIC}} for details.}

\item{k}{Multiplier of model size penalty, the default is \code{k = 2} for AIC. Use \code{k = log(n)} for BIC, or \code{k = log(p)} for RIC.}

\item{intercept}{Should an intercept be included in the model? Default is TRUE.}

\item{normalize}{Should the design matrix be normalized? Default is TRUE.}

\item{verbose}{Print out progress along the way? Default is FALSE.}
}
\value{
An object of class "groupfs" containing information about the sequence of models in the forward stepwise algorithm. Call the function \code{\link{groupfsInf}} on this object to compute selective p-values.
}
\description{
This function implements forward selection of linear models almost identically to \code{\link{stepAIC}} with \code{direction = "forward"}. The reason this is a separate function from \code{\link{fs}} is that groups of variables (e.g. dummies encoding levels of a categorical variable) must be handled differently in the selective inference framework.
}
\examples{
x = matrix(rnorm(20*40), nrow=20)
index = sort(rep(1:20, 2))
y = rnorm(20) + 2 * (x[,1] - x[,2]) - (x[,3] - x[,4])
fit = groupfs(x, y, index, maxsteps = 5)
pvals = groupfsInf(fit)
}
\seealso{
\code{\link{groupfsInf}}
}

