% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selac.R
\name{GetSelacSiteLikelihoods}
\alias{GetSelacSiteLikelihoods}
\title{Calculate site likelihoods under SelAC}
\usage{
GetSelacSiteLikelihoods(selac.obj, codon.data.path,
  aa.optim.input = NULL, fasta.rows.to.keep = NULL)
}
\arguments{
\item{selac.obj}{An object of class SELAC.}

\item{codon.data.path}{Provides the path to the directory containing the gene specific fasta files of coding data.}

\item{aa.optim.input}{A list of optimal amino acids with each list element designating a character vector for each gene. The optimal amino acids be the MLE from a selac run (default) or a list of user defined optimal A.A.}

\item{fasta.rows.to.keep}{Indicates which rows to remove in the input fasta files.}
}
\description{
Calculates the likelihoods across sites and across genes under SELAC
}
\details{
The purpose of this function is to provide the site likelihoods across genes. It is also flexible in that it allows different hypotheses about optimal acids across genes and/or site. The output is a list object, with each list entry designating 1) the tot.likelihood for that gene, and 2) the site likelihoods for that gene.
}
