\name{audiomoth}

\alias{audiomoth}

\title{Reading and interpreting Audiomoth file name}

\description{This function reads and decomposes the files names
  generated by an Audiomoth device,
  audio digal recorders produced by the society Open Acoustic Devices.}

\usage{audiomoth(x, tz = "")}

\arguments{
  \item{x}{a character vector with \code{.wav} file names.}
  \item{tz}{a character vector defining a time zone specification. See \code{as.POSIXct}}
}

\details{The digital recorder Audiomoth produced by Open Acoustic
  Devices (\url{https://www.openacousticdevices.info/}) generates .wav
  files which names contains information about the time of
  recording. The information is encoded in hexadecimal
  (e.g. "5E9089F0"). The function \code{audiomoth} decodes this
  information so that time of recording can be retrieved in numeric or
  time format.}

\value{The function returns a \code{data.frame} with the following
  columns:
\item{year}{year of recording, numeric}
\item{month}{month of recording, numeric}
\item{day}{day of recording, numeric}
\item{hour}{hour of recording, numeric}
\item{min}{minute of recording, numeric}
\item{sec}{second of recording, numeric}
\item{time}{time in \code{POSIX} format}
}

\references{See Open Acoustic Devices website for details regarding
  the Audiomoth: \url{https://www.openacousticdevices.info/}.}

\author{Jerome Sueur}

\note{For the time zone see the 607 time zone names stored in
  \code{OlsonNames}.\cr
  The file names of Audiomoth may change with time. There is no
  guarantee that the function will be updated on time.
}

\seealso{\code{\link{audiomoth.rename}}, \code{\link{as.POSIXct}}, \code{\link{OlsonNames}}, \code{\link{songmeter}}}

\examples{
## HEXADECIMAL EXAMPLES (OLD FORMAT)
## recording done on Friday 10 April 2020 16:54:44 UTC
## computer time zone (local time, Europe, Paris for the test)
audiomoth("5E90A4D4.WAV")
## UTC
audiomoth("5E90A4D4.WAV", tz="UTC")
## GMT (= UTC as UTC and GMT are synonyms)    
audiomoth("5E90A4D4.WAV", tz="GMT")
## UTC -2
audiomoth("5E90A4D4.WAV", tz="Etc/GMT-2")
## in Asia, Japan
audiomoth("5E90A4D4.WAV", tz="Japan")
## in South-America, Cayenne
audiomoth("5E90A4D4.WAV", tz="America/Cayenne")  
## several files
filenames <- c("5E914ED0.WAV", "5E915128.WAV",
"5E915380.WAV", "5E9155D8.WAV", "5E915830.WAV",
"5E915A88.WAV", "5E915CE0.WAV", "5E915F38.WAV",
"5E916190.WAV", "5E9163E8.WAV")
audiomoth(filenames)
## YYYYMMDD_HHMMSS.WAV FORMAT (ACTUAL FORMAT)
## single file
audiomoth("20230715_150000.wav")
## several files
filenames <- c("20230715_150000.wav", "20230715_151500.wav",
"20230715_153000.wav", "20230715_154500.wav")
audiomoth(filenames)
}

\keyword{input}
\keyword{data}
