% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secure.R
\name{rfit}
\alias{rfit}
\title{Fit reduced rank regression}
\usage{
rfit(Y, X, nrank = nrank)
}
\arguments{
\item{Y}{a matrix of response (n by q)}

\item{X}{a matrix of covariate (n by p)}

\item{nrank}{an integer specifying the desired rank}
}
\value{
\item{coef}{reduced rank estimate}
}
\description{
fit multivariate reduced rank regression for a specified rank.
}
\examples{
#require(secure)
Y <- matrix(rnorm(400), 100, 4)
X <- matrix(rnorm(800), 100, 8)
rfit <- rfit(Y, X, nrank = 3)
}

