% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasrescheck.R
\name{seasrescheck}
\alias{seasrescheck}
\title{Seasonal Residual Checks}
\usage{
seasrescheck(res)
}
\arguments{
\item{res}{residuals from some time series regression model.}
}
\description{
Tests the residuals for any remaining seasonality.
}
\details{
Plots: i) histogram of the residuals, ii) a scatter plot against residual
order, iii) the autocovariance, iv) the cumulative periodogram (see
\code{\link{cpgram}})
}
\examples{
\donttest{
# cardiovascular disease data
# (use an offset of the scaled number of days in a month)
data(CVD)
model = cosinor(cvd~1, date='month', data=CVD, type='monthly',
                family=poisson(), offsetmonth=TRUE)
seasrescheck(resid(model))
}

}
\author{
Adrian Barnett \email{a.barnett<at>qut.edu.au}
}
