% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seal.R
\name{seal}
\alias{seal}
\alias{seal}
\title{Sealing the test results}
\usage{
seal(test, load_testthat = FALSE, clip = TRUE, ts = TRUE,
  mask_seal = FALSE)
}
\arguments{
\item{test}{test}

\item{load_testthat}{include \code{library(testthat)} when \emph{TRUE}}

\item{clip}{If \emph{TRUE} will overwrite the system clipboard.
When clipr is not available, The clip arguments is forcibly \emph{FALSE}.}

\item{ts}{include comments that timestamp?}

\item{mask_seal}{Whether to comment out after executing the function.
Default \emph{FALSE}. This option is effective only when using RStudio.}
}
\description{
Recording the state of the object
}
\examples{
\dontrun{
x <- 3.14
tests <- transcribe(x, seal = FALSE)
seal(tests, load_testthat = TRUE)
seal(tests, load_testthat = FALSE)
seal(tests, load_testthat = FALSE, clip = FALSE)
}
}
