% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUIfunctions.R
\name{subsetMicrodata}
\alias{subsetMicrodata}
\title{subsetMicrodata}
\usage{
subsetMicrodata(obj, type, n)
}
\arguments{
\item{obj}{an object of class \code{\link{data.frame}} containing micro data}

\item{type}{algorithm used to sample from original microdata. Currently supported choices are
\itemize{
\item \code{n_perc}{ the restricted microdata will be a \code{n-percent} sample of the original microdata.}
\item \code{first_n}{ only the first \code{n} observations will be used.}
\item \code{every_n}{ the restricted microdata set consists of every \code{n-th} record.}
\item \code{size_n}{ a total of \code{n} observations will be randomly drawn.}
}}

\item{n}{numeric vector of length 1 specifying the specific parameter with respect to argument \code{type}.}
}
\value{
an object of class \code{\link{sdcMicroObj-class}} with modified slot \code{@origData}.
}
\description{
allows to restrict original data to only a subset. This may be useful to test some anonymization
methods. This function will only be used in the graphical user interface \code{\link{sdcApp}}.
}
\author{
Bernhard Meindl
}
