% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sampleDonor_cpp}
\alias{sampleDonor_cpp}
\title{Random sample for donor records}
\usage{
sampleDonor_cpp(
  data,
  similar_cpp,
  hid,
  IDswap,
  IDswap_pool_vec,
  prob,
  seed = 123456L
)
}
\arguments{
\item{data}{micro data containing the hierarchy levels and household ID}

\item{similar_cpp}{List where each entry corresponds to column indices of variables in \code{data} which should be considered when swapping households.}

\item{hid}{column index in \code{data} which refers to the household identifier.}

\item{IDswap}{vector containing records for which a donor needs to be sampled}

\item{IDswap_pool_vec}{set from which `IDswap` was drawn}

\item{prob}{a vector of probability weights for obtaining the elements of the vector being sampled.}

\item{seed}{integer setting the sampling seed}
}
\description{
Randomly select donor records given a probability weight vector. This sampling procedure is implemented differently than \code{\link{randSample_cpp}} to speed up performance of C++-function \code{recordSwap()}.
\cr
\strong{NOTE:} This is an internal function used for testing the C++-function \code{sampleDonor} which is used inside the C++-function \code{recordSwap()}.
}
