% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dRisk.R
\docType{methods}
\name{dRisk}
\alias{dRisk}
\alias{dRisk,data.frame-method}
\alias{dRisk,matrix-method}
\alias{dRisk,sdcMicroObj-method}
\alias{dRisk-methods}
\title{overal disclosure risk}
\usage{
dRisk(obj, ...)
}
\arguments{
\item{obj}{original data or object of class \code{\link{sdcMicroObj-class}}}

\item{...}{possible arguments are:
\itemize{
\item {xm}{perturbed data}
\item {k}{percentage of the standard deviation}}}
}
\value{
The disclosure risk or/and the modified \code{\link{sdcMicroObj-class}}
}
\description{
Distance-based disclosure risk estimation via standard deviation-based
intervals around observations.
}
\details{
An interval (based on the standard deviation) is built around each value of
the perturbed value.  Then we look if the original values lay in these
intervals or not. With parameter k one can enlarge or down scale the
interval.
}
\section{Methods}{
 \describe{
\item{list("signature(obj = \"data.frame\")")}{}
\item{list("signature(obj = \"matrix\")")}{}
\item{list("signature(obj = \"sdcMicroObj\")")}{}}
}
\examples{

data(free1)
m1 <- microaggregation(free1[, 31:34], method="onedims", aggr=3)
m2 <- microaggregation(free1[, 31:34], method="pca", aggr=3)
dRisk(obj=free1[, 31:34], xm=m1$mx)
dRisk(obj=free1[, 31:34], xm=m2$mx)
dUtility(obj=free1[, 31:34], xm=m1$mx)
dUtility(obj=free1[, 31:34], xm=m2$mx)

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
## this is already made internally: sdc <- dRisk(sdc)
## and already stored in sdc

}
\author{
Matthias Templ
}
\references{
see method SDID in
\url{http://vneumann.etse.urv.es/webCrises/publications/isijcr/lncs3050Outlier.pdf}
}
\seealso{
\code{\link{dUtility}}, \code{\link{dUtility}}
}
\keyword{manip}

