% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation-templates.R
\name{forecast_types}
\alias{forecast_types}
\title{Documentation template for forecast types}
\description{
Documentation template for forecast types
}
\section{Forecast unit}{
In order to score forecasts, \code{scoringutils} needs to know which of the rows
of the data belong together and jointly form a single forecasts. This is
easy e.g. for point forecast, where there is one row per forecast. For
quantile or sample-based forecasts, however, there are multiple rows that
belong to a single forecast.

The \emph{forecast unit} or \emph{unit of a single forecast} is then described by the
combination of columns that uniquely identify a single forecast.
For example, we could have forecasts made by different models in various
locations at different time points, each for several weeks into the future.
The forecast unit could then be described as
\code{forecast_unit = c("model", "location", "forecast_date", "forecast_horizon")}.
\code{scoringutils} automatically tries to determine the unit of a single
forecast. It uses all existing columns for this, which means that no columns
must be present that are unrelated to the forecast unit. As a very simplistic
example, if you had an additional row, "even", that is one if the row number
is even and zero otherwise, then this would mess up scoring as \code{scoringutils}
then thinks that this column was relevant in defining the forecast unit.

In order to avoid issues, we recommend setting the forecast unit explicitly,
using the \code{forecast_unit} argument. This will simply drop unneeded columns,
while making sure that all necessary, 'protected columns' like "predicted"
or "observed" are retained.
}

\keyword{internal}
