% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{add_relative_skill}
\alias{add_relative_skill}
\title{Add relative skill scores based on pairwise comparisons}
\usage{
add_relative_skill(
  scores,
  compare = "model",
  by = NULL,
  metric = intersect(c("wis", "crps", "brier_score"), names(scores)),
  baseline = NULL,
  ...
)
}
\arguments{
\item{scores}{An object of class \code{scores} (a data.table with
scores and an additional attribute \code{metrics} as produced by \code{\link[=score]{score()}}).}

\item{compare}{Character vector with a single colum name that defines the
elements for the pairwise comparison. For example, if this is set to
"model" (the default), then elements of the "model" column will be
compared.}

\item{by}{Character vector with column names that define further grouping
levels for the pairwise comparisons. By default this is \code{NULL} and there
will be one relative skill score per distinct entry of the column selected
in \code{compare}. If further columns are given here, for example, \code{by = "location"} with \code{compare = "model"}, then one separate relative skill
score is calculated for every model in every location.}

\item{metric}{A string with the name of the metric for which
a relative skill shall be computed. By default this is either "crps",
"wis" or "brier_score" if any of these are available.}

\item{baseline}{A string with the name of a model. If a baseline is
given, then a scaled relative skill with respect to the baseline will be
returned. By default (\code{NULL}), relative skill will not be scaled with
respect to a baseline model.}

\item{...}{Additional arguments for the comparison between two models. See
\code{\link[=compare_forecasts]{compare_forecasts()}} for more information.}
}
\description{
Adds a columns with relative skills computed by running
pairwise comparisons on the scores.
For more information on
the computation of relative skill, see \code{\link[=get_pairwise_comparisons]{get_pairwise_comparisons()}}.
Relative skill will be calculated for the aggregation level specified in
\code{by}.
}
\keyword{scoring}
