% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pit.R
\name{pit_df}
\alias{pit_df}
\title{Probability Integral Transformation (data.frame Format)}
\usage{
pit_df(
  data,
  plot = TRUE,
  full_output = FALSE,
  n_replicates = 100,
  num_bins = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{a data.frame with the following columns: `true_value`,
`prediction`, `sample`}

\item{plot}{logical. If TRUE, a histogram of the PIT values will be returned
as well}

\item{full_output}{return all individual p_values and computed u_t values
for the randomised PIT. Usually not needed.}

\item{n_replicates}{the number of tests to perform,
each time re-randomising the PIT}

\item{num_bins}{the number of bins in the PIT histogram (if plot == TRUE)
If not given, the square root of n will be used}

\item{verbose}{if TRUE (default is FALSE) more error messages are printed.
Usually, this should not be needed, but may help with debugging.}
}
\value{
a list with the following components:
\itemize{
\item \code{data}: the input data.frame (not including rows where prediction is `NA`),
with added columns `pit_p_val` and `pit_sd`
\item \code{hist_PIT} a plot object with the PIT histogram. Only returned
if \code{plot == TRUE}. Call
\code{plot(PIT(...)$hist_PIT)} to display the histogram.
\item \code{p_values}: all p_values generated from the Anderson-Darling tests on the
(randomised) PIT. Only returned if \code{full_output = TRUE}
\item \code{u}: the u_t values internally computed. Only returned if
\code{full_output = TRUE}
}
}
\description{
Wrapper around `pit()` for use in data.frames
}
\details{
see \code{\link{pit}}
}
\examples{
example <- scoringutils::continuous_example_data
result <- pit_df(example, full_output = TRUE)

}
\references{
Sebastian Funk, Anton Camacho, Adam J. Kucharski, Rachel Lowe,
Rosalind M. Eggo, W. John Edmunds (2019) Assessing the performance of
real-time epidemic forecasts: A case study of Ebola in the Western Area
region of Sierra Leone, 2014-15, <doi:10.1371/journal.pcbi.1006785>
}
