% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoringRules_wrappers.R
\name{crps}
\alias{crps}
\title{Ranked Probability Score}
\usage{
crps(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the
number of Monte Carlo samples}
}
\value{
vector with the scoring values
}
\description{
Wrapper around the \code{\link[scoringRules]{crps_sample}} function from the
\code{scoringRules} package. Can be used for continuous as well as integer
valued forecasts
}
\examples{
true_values <- rpois(30, lambda = 1:30)
predictions <- replicate(200, rpois(n = 30, lambda = 1:30))
crps(true_values, predictions)
}
\references{
Alexander Jordan, Fabian Krüger, Sebastian Lerch, Evaluating Probabilistic
Forecasts withscoringRules, https://arxiv.org/pdf/1709.04743.pdf
}
