% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_clouds.R
\name{word_cloud_plot}
\alias{word_cloud_plot}
\title{Text Mine a Given Column and Create a Word Cloud}
\usage{
word_cloud_plot(
  data = NULL,
  text_column = NULL,
  word_count = 50,
  known_bigrams = c("working group")
)
}
\arguments{
\item{data}{dataframe containing at least one column}

\item{text_column}{character, name of column in dataframe given to `data` that contains the text to be mined}

\item{word_count}{numeric, number of words to be returned (counts from most to least frequent)}

\item{known_bigrams}{character vector, all bigrams (two-word phrases) to be mined before mining for single words}
}
\value{
dataframe of one column (named 'word') that can be used for word cloud creation. One row per bigram supplied in `known_bigrams` or single word (not including "stop words")
}
\description{
Mines a user-defined column of text and creates a word cloud from the identified words and bigrams.
}
