% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CsvToJMat}
\alias{CsvToJMat}
\title{CsvToJMat}
\usage{
CsvToJMat(
  ifname,
  ofname,
  mtype = "sparse",
  csep = ",",
  ctype = "raw",
  valuetype = "float",
  transpose = FALSE,
  comment = ""
)
}
\arguments{
\item{ifname}{A string with the name of the .csv text file.}

\item{ofname}{A string with the name of the binary output file.}

\item{mtype}{A string to indicate the matrix type: 'full' or 'sparse'. Default: 'sparse'}

\item{csep}{The character used as separator in the .csv file. Default: ',' (comma)}

\item{ctype}{The string 'raw' or 'log1' to write raw counts or log(counts+1), or the normalized versions, 'rawn' and 'log1n', which normalize ALWAYS BY COLUMNS (before transposition, if requested to transpose). The logarithm is taken base 2. Default: raw}

\item{valuetype}{The data type to store the matrix. It must be one of the strings 'uint32', 'float' or 'double'. Default: float}

\item{transpose}{Boolean to indicate if the matrix should be transposed before writing. See Details for a comment about this. Default: FALSE}

\item{comment}{A comment to be stored with the matrix. Default: "" (no comment)}
}
\value{
No return value, called for side effects (creates a file)
}
\description{
Gets a csv file and writes to a disk file the binary matrix of counts contained in it in the jmatrix binary format.\cr
First line of the .csv is supposed to have the field names.\cr
First column of each line is supposed to have the field name.\cr
The fields are supposed to be separated by one occurrence of a character-field sepparator (usually, comma or tab)
}
\details{
The parameter transpose has the default value of FALSE. But don't forget to set it to TRUE if you want the cells
(which in single cell common practice are by columns) to be written by rows. This will be needed later to calculate
the dissimilarity matrix, if this is the next step of your workflow. See help of CalcAndWriteDissimilarityMatrix
}
\examples{
# Since we have no a .csv file to test, we will generate one with another funcion of this package
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
tmpfile2=paste0(tempdir(),"/Rfullfloat2.bin")
tmpcsvfile1=paste0(tempdir(),"/Rfullfloat.csv")
JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
JMatToCsv(tmpfile1,tmpcsvfile1)
CsvToJMat(tmpcsvfile1,tmpfile2)
# It can be checked that files Rfullfloat.bin and Rfullfloat2.bin contain the same data
# (even hey differ in the comment, which has been eliminated when converting to csv)
}
