% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.cloud.respondent.variables.R
\name{encode.cloud.respondent.variables}
\alias{encode.cloud.respondent.variables}
\title{Encodes Cloud Research respondent information in form suitable for calculating sampling weights}
\usage{
encode.cloud.respondent.variables(dataset)
}
\arguments{
\item{dataset}{Dataset containing Cloud Research respondent demographic information}
}
\value{
Returns dataset with encoded variables added: black, ba_or_more, hhincome_over50k, age35plus, woman, hispanic, and respondent_na.
}
\description{
Encodes Cloud research respondent information with names and values suitable
             for calculating sampling weights. All variables encoded and added to dataset are booleans. The variable respondent_na is TRUE
             if the respondent's information is "Prefer not to say" or missing on any variable.
}
\examples{
   library(sate)

   example <- data.frame(Race = sample(x=c("Black or African American", "Other"),
                                       size=10, replace=TRUE),
                         Education = sample(x=c("Bachelor's degree (for example: BA, AB, BS)",
                                            "Other"), size=10, replace=TRUE),
                         Household.Income = sample(x=c("$70,000-$79,999", "Other"),
                                                   size=10, replace=TRUE),
                         Age = sample(x=18:80, size=10, replace=TRUE),
                         Gender = sample(x=c("Woman", "Man", "Prefer not to say"),
                                         size=10, replace=TRUE),
                         Ethnicity = sample(x=c("No, not of Hispanic, Latino, or Spanish origin",
                                            "Other"), size=10, replace=TRUE))
   dataset.encoded <- encode.cloud.respondent.variables(dataset=example)

}
