eblup.saery.AR1 <-
function(X, ydi, D, md, sigma2edi, plot, type, B){
  
  fit <- REML.saery.AR1(X, ydi, D, md, sigma2edi)
  sigmau1.hat <- fit[[1]][1]
  sigmau2.hat <- fit[[1]][2]
  rho.hat  <- fit[[1]][3]
  beta.u.hat <- BETA.U.saery.AR1(X, ydi, D, md, sigma2edi, sigmau1.hat, sigmau2.hat, rho.hat)
  
  u1d.hat <- beta.u.hat[[2]]
  u1di.hat <- list()
  for(d in 1:D)
    u1di.hat[[d]] <- rep(u1d.hat[d,1],md[d])
  u1di.hat <- unlist(u1di.hat)
  
  mudi.hat <- as.vector(X%*%beta.u.hat[[1]] + u1di.hat + beta.u.hat[[3]])                      
  mse <- mse.saery.boot.AR1(X, D, md, beta.u.hat[[1]], sigma2edi, sigmau1.hat, sigmau2.hat, rho.hat, Fsig=fit[[2]], type, B)
  resid <- ydi-mudi.hat
  
  if(plot)
    plot.saery(ydi, mudi.hat, mse, sigma2edi)
  
  return(data.frame(Domain=rep(1:D,md), Period=sequence(md), direct=ydi, eblup=mudi.hat, var.direct=sigma2edi, mse.eblup=mse, resid=resid))
  
}
