% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{copy}
\alias{copy}
\alias{s3_file_copy}
\alias{s3_dir_copy}
\title{Copy files and directories}
\usage{
s3_file_copy(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)

s3_dir_copy(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{path}{(character): path to a local directory of file or a uri.}

\item{new_path}{(character): path to a local directory of file or a uri.}

\item{max_batch}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\value{
character vector of s3 uri paths
}
\description{
\code{s3_file_copy} copies files

\code{s3_dir_copy} copies the directory recursively to the new location
}
\examples{
\dontrun{
# Require AWS S3 credentials

temp_file = "temp.txt"
file.create(temp_file)

s3_file_copy(
    temp_file,
    "s3://MyBucket/temp_file.txt"
 )
}
}
