% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clim.R
\name{Clim}
\alias{Clim}
\title{Compute Bias Corrected Climatologies}
\usage{
Clim(
  exp,
  obs,
  time_dim = "sdate",
  dat_dim = c("dataset", "member"),
  method = "clim",
  ftime_dim = "ftime",
  memb = TRUE,
  memb_dim = "member",
  na.rm = TRUE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numeric array of experimental data with at least dimension
'time_dim'.}

\item{obs}{A named numeric array of observational data that has the same 
dimension as 'exp' except 'dat_dim'.}

\item{time_dim}{A character string indicating the name of dimension along
which the climatologies are computed. The default value is 'sdate'.}

\item{dat_dim}{A character vector indicating the name of the dataset and 
member dimensions. If data at one startdate (i.e., 'time_dim') are not 
complete along 'dat_dim', this startdate along 'dat_dim' will be discarded.
If there is no dataset dimension, it can be NULL, however, it will be more 
efficient to simply use mean() to do the calculation. The default value is 
"c('dataset', 'member')".}

\item{method}{A character string indicating the method to be used. The 
options include 'clim' (per-pair method), 'kharin' (Kharin method), and 
'NDV' (Fuckar method). The default value is 'clim'.}

\item{ftime_dim}{A character string indicating the name of forecast time
dimension. Only used when method = 'NDV'. The default value is 'ftime'.}

\item{memb}{A logical value indicating whether to remain 'memb_dim' dimension
(TRUE) or do ensemble mean over 'memb_dim' (FALSE). The default value is 
TRUE.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. Only used when parameter 'memb' is FALSE. It must be one element
in 'dat_dim'. The default value is 'member'.}

\item{na.rm}{A logical value indicating whether to remove NA values along 
'time_dim' when calculating climatology (TRUE) or return NA if there is NA 
along 'time_dim' (FALSE). The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of 2:
\item{$clim_exp}{
 A numeric array with the same dimensions as parameter 'exp' but 
 dimension 'time_dim' is moved to the first position. If parameter 'method'
 is 'clim', dimension 'time_dim' is removed. If parameter 'memb' is FALSE,
 dimension 'memb_dim' is also removed.
}
\item{$clim_obs}{
 A numeric array with the same dimensions as  parameter 'obs' 
 except dimension 'time_dim' is removed. If parameter 'memb' is FALSE,
 dimension 'memb_dim' is also removed.
}
}
\description{
This function computes per-pair climatologies for the experimental 
and observational data using one of the following methods:
\enumerate{
 \item{per-pair method (Garcia-Serrano and Doblas-Reyes, CD, 2012 
       https://doi.org/10.1007/s00382-012-1413-1)}
 \item{Kharin method (Kharin et al, GRL, 2012 https://doi.org/10.1029/2012GL052647)}
 \item{Fuckar method (Fuckar et al, GRL, 2014 https://doi.org/10.1002/2014GL060815)}
}
Per-pair climatology means that only the startdates covered by the 
whole experiments/observational dataset will be used. In other words, the 
startdates which are not all available along 'dat_dim' dimension of both
the 'exp' and 'obs' are excluded when computing the climatologies.
Kharin method is the linear trend bias correction method, and Fuckar method 
is the initial condition bias correction method. The two methods both do the
per-pair correction beforehand.
}
\examples{
# Load sample data as in Load() example:
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
clim2 <- Clim(sampleData$mod, sampleData$obs, method = 'kharin', memb = FALSE)
\dontrun{
PlotClim(clim$clim_exp, clim$clim_obs, 
        toptitle = paste('sea surface temperature climatologies'), 
        ytitle = 'K', monini = 11, listexp = c('CMIP5 IC3'), 
        listobs = c('ERSST'), biglab = FALSE)
}
}
